/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.editor;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.xml.util.HtmlUtil;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.DartTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartEnterInStringHandler
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        String openingQuoteText;
        int psiOffset;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/editor/DartEnterInStringHandler", "preprocessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/editor/DartEnterInStringHandler", "preprocessEnter"));
        }
        if (caretOffsetRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffsetRef", "com/jetbrains/lang/dart/ide/editor/DartEnterInStringHandler", "preprocessEnter"));
        }
        if (caretAdvanceRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretAdvanceRef", "com/jetbrains/lang/dart/ide/editor/DartEnterInStringHandler", "preprocessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/lang/dart/ide/editor/DartEnterInStringHandler", "preprocessEnter"));
        }
        if (file.getLanguage() != DartLanguage.INSTANCE && !HtmlUtil.isHtmlFile((PsiElement)file)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        PsiElement psiAtOffset = file.findElementAt(caretOffset);
        if (psiAtOffset == null || (psiOffset = psiAtOffset.getTextRange().getStartOffset()) > caretOffset) {
            return EnterHandlerDelegate.Result.Continue;
        }
        ASTNode node = psiAtOffset.getNode();
        IElementType nodeType = node.getElementType();
        if ((nodeType == DartTokenTypes.SHORT_TEMPLATE_ENTRY_START || nodeType == DartTokenTypes.LONG_TEMPLATE_ENTRY_START) && caretOffset == psiOffset) {
            node = node.getTreeParent();
            nodeType = node.getElementType();
        }
        if (nodeType == DartTokenTypes.RAW_TRIPLE_QUOTED_STRING && caretOffset >= psiOffset + "r'''".length()) {
            return EnterHandlerDelegate.Result.DefaultSkipIndent;
        }
        if (nodeType == DartTokenTypes.RAW_SINGLE_QUOTED_STRING && caretOffset >= psiOffset + "r'".length()) {
            char quote = node.getText().charAt(1);
            DartEnterInStringHandler.breakString("r" + quote, String.valueOf(quote), caretOffsetRef, caretAdvanceRef, editor.getDocument());
            return EnterHandlerDelegate.Result.Default;
        }
        if ((nodeType == DartTokenTypes.REGULAR_STRING_PART || nodeType == DartTokenTypes.CLOSING_QUOTE || nodeType == DartTokenTypes.SHORT_TEMPLATE_ENTRY || nodeType == DartTokenTypes.LONG_TEMPLATE_ENTRY) && (openingQuoteText = DartEnterInStringHandler.getOpeningQuoteText(node)) != null) {
            if (openingQuoteText.length() == 1) {
                DartEnterInStringHandler.breakString(openingQuoteText, openingQuoteText, caretOffsetRef, caretAdvanceRef, editor.getDocument());
                return EnterHandlerDelegate.Result.Default;
            }
            return EnterHandlerDelegate.Result.DefaultSkipIndent;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    @Nullable
    private static String getOpeningQuoteText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/ide/editor/DartEnterInStringHandler", "getOpeningQuoteText"));
        }
        for (ASTNode prev = node.getTreePrev(); prev != null; prev = prev.getTreePrev()) {
            if (prev.getElementType() != DartTokenTypes.OPEN_QUOTE) continue;
            return prev.getText();
        }
        return null;
    }

    private static void breakString(@NotNull String startQuote, @NotNull String endQuote, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull Document document) {
        if (startQuote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startQuote", "com/jetbrains/lang/dart/ide/editor/DartEnterInStringHandler", "breakString"));
        }
        if (endQuote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endQuote", "com/jetbrains/lang/dart/ide/editor/DartEnterInStringHandler", "breakString"));
        }
        if (caretOffsetRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffsetRef", "com/jetbrains/lang/dart/ide/editor/DartEnterInStringHandler", "breakString"));
        }
        if (caretAdvanceRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretAdvanceRef", "com/jetbrains/lang/dart/ide/editor/DartEnterInStringHandler", "breakString"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/lang/dart/ide/editor/DartEnterInStringHandler", "breakString"));
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        int caretAdvance = (Integer)caretAdvanceRef.get();
        document.insertString(caretOffset, (CharSequence)(endQuote + startQuote));
        caretOffsetRef.set((Object)(caretOffset += endQuote.length()));
        caretAdvanceRef.set((Object)(caretAdvance += startQuote.length()));
    }
}

