/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.editor;

import com.intellij.openapi.editor.DefaultLineWrapPositionStrategy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.GenericLineWrapPositionStrategy;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartLineWrapPositionStrategy
extends DefaultLineWrapPositionStrategy {
    public DartLineWrapPositionStrategy() {
        this.addRule(new GenericLineWrapPositionStrategy.Rule('\\', GenericLineWrapPositionStrategy.WrapCondition.BEFORE));
    }

    public int calculateWrapPosition(@NotNull Document document, @Nullable Project project, int startOffset, int endOffset, int maxPreferredOffset, boolean allowToBeyondMaxPreferredOffset, boolean virtual) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/lang/dart/ide/editor/DartLineWrapPositionStrategy", "calculateWrapPosition"));
        }
        int pos = super.calculateWrapPosition(document, project, startOffset, endOffset, maxPreferredOffset, allowToBeyondMaxPreferredOffset, virtual);
        if (pos < 0) {
            return pos;
        }
        char ch = document.getCharsSequence().charAt(pos);
        if (ch == '\'' || ch == '\"') {
            return maxPreferredOffset;
        }
        return pos;
    }

    protected boolean canUseOffset(@NotNull Document document, int offset, boolean virtual) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/lang/dart/ide/editor/DartLineWrapPositionStrategy", "canUseOffset"));
        }
        CharSequence chars = document.getCharsSequence();
        char charAtOffset = chars.charAt(offset);
        return charAtOffset != '.' || offset <= 0 || chars.charAt(offset - 1) != '.';
    }
}

