/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.editor;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.util.UsefulPsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartSelectionFilter
implements Condition<PsiElement> {
    public boolean value(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/lang/dart/ide/editor/DartSelectionFilter", "value"));
        }
        return DartSelectionFilter.getSiblingSemicolonIfExpression(psiElement) == null;
    }

    @Nullable
    public static PsiElement getSiblingSemicolonIfExpression(@NotNull PsiElement psiElement) {
        PsiElement next;
        PsiElement last;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/lang/dart/ide/editor/DartSelectionFilter", "getSiblingSemicolonIfExpression"));
        }
        if (psiElement instanceof DartExpression && (last = PsiTreeUtil.getDeepestLast((PsiElement)psiElement)).getNode().getElementType() != DartTokenTypes.SEMICOLON && (next = UsefulPsiTreeUtil.getNextSiblingSkippingWhiteSpacesAndComments(psiElement)) != null && next.getNode().getElementType() == DartTokenTypes.SEMICOLON) {
            return next;
        }
        return null;
    }
}

