/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.editor;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.PsiBasedStripTrailingSpacesFilter;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.psi.DartRecursiveVisitor;
import com.jetbrains.lang.dart.psi.DartStringLiteralExpression;
import org.jetbrains.annotations.NotNull;

public class DartStripTrailingSpacesFilterFactory
extends PsiBasedStripTrailingSpacesFilter.Factory {
    @NotNull
    protected PsiBasedStripTrailingSpacesFilter createFilter(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/lang/dart/ide/editor/DartStripTrailingSpacesFilterFactory", "createFilter"));
        }
        DartStripTrailingSpacesFilter dartStripTrailingSpacesFilter = new DartStripTrailingSpacesFilter(document);
        if (dartStripTrailingSpacesFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/editor/DartStripTrailingSpacesFilterFactory", "createFilter"));
        }
        return dartStripTrailingSpacesFilter;
    }

    protected boolean isApplicableTo(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/jetbrains/lang/dart/ide/editor/DartStripTrailingSpacesFilterFactory", "isApplicableTo"));
        }
        return language == DartLanguage.INSTANCE;
    }

    private static class DartStripTrailingSpacesFilter
    extends PsiBasedStripTrailingSpacesFilter {
        protected DartStripTrailingSpacesFilter(@NotNull Document document) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/lang/dart/ide/editor/DartStripTrailingSpacesFilterFactory$DartStripTrailingSpacesFilter", "<init>"));
            }
            super(document);
        }

        protected void process(@NotNull PsiFile psiFile) {
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/lang/dart/ide/editor/DartStripTrailingSpacesFilterFactory$DartStripTrailingSpacesFilter", "process"));
            }
            DartRecursiveVisitor visitor = new DartRecursiveVisitor(){

                @Override
                public void visitStringLiteralExpression(@NotNull DartStringLiteralExpression literalExpression) {
                    if (literalExpression == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalExpression", "com/jetbrains/lang/dart/ide/editor/DartStripTrailingSpacesFilterFactory$DartStripTrailingSpacesFilter$1", "visitStringLiteralExpression"));
                    }
                    super.visitStringLiteralExpression(literalExpression);
                    for (ASTNode child = literalExpression.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
                        IElementType type = child.getElementType();
                        if (type != DartTokenTypes.RAW_TRIPLE_QUOTED_STRING && type != DartTokenTypes.REGULAR_STRING_PART) continue;
                        this.disableRange(child.getTextRange(), false);
                    }
                }
            };
            psiFile.accept((PsiElementVisitor)visitor);
        }
    }
}

