/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.editor;

import com.intellij.codeInsight.editorActions.wordSelection.AbstractWordSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.ide.editor.DartSelectionFilter;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DartWordSelectionHandler
extends AbstractWordSelectioner {
    public boolean canSelect(PsiElement e) {
        return e.getLanguage() == DartLanguage.INSTANCE;
    }

    public List<TextRange> select(@NotNull PsiElement psiElement, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/lang/dart/ide/editor/DartWordSelectionHandler", "select"));
        }
        if (editorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorText", "com/jetbrains/lang/dart/ide/editor/DartWordSelectionHandler", "select"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/editor/DartWordSelectionHandler", "select"));
        }
        List ranges = super.select(psiElement, editorText, cursorOffset, editor);
        PsiElement semicolon = DartSelectionFilter.getSiblingSemicolonIfExpression(psiElement);
        if (semicolon != null) {
            DartWordSelectionHandler.includeSemicolonInRanges(ranges, psiElement.getTextRange(), semicolon.getTextRange().getEndOffset());
        }
        return ranges;
    }

    private static void includeSemicolonInRanges(@NotNull List<TextRange> ranges, @NotNull TextRange elementWithoutSemicolonRange, int semicolonEndOffset) {
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/jetbrains/lang/dart/ide/editor/DartWordSelectionHandler", "includeSemicolonInRanges"));
        }
        if (elementWithoutSemicolonRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementWithoutSemicolonRange", "com/jetbrains/lang/dart/ide/editor/DartWordSelectionHandler", "includeSemicolonInRanges"));
        }
        for (int i = 0; i < ranges.size(); ++i) {
            TextRange range = ranges.get(i);
            if (range.getStartOffset() > elementWithoutSemicolonRange.getStartOffset() || range.getEndOffset() != elementWithoutSemicolonRange.getEndOffset()) continue;
            ranges.set(i, TextRange.create((int)range.getStartOffset(), (int)semicolonEndOffset));
        }
    }
}

