/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.errorTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.errorTreeView.DartFeedbackBuilder;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsView;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalysisServerStatusAction
extends DumbAwareAction {
    private static final Icon STATUS_GOOD = AllIcons.Process.State.GreenOK;
    private static final Icon STATUS_UNKNOWN = AllIcons.Process.State.YellowStr;
    private static final Icon STATUS_BAD = AllIcons.Process.State.RedExcl;

    public AnalysisServerStatusAction() {
        super(DartBundle.message("analysis.server.status.good.text", new Object[0]), DartBundle.message("analysis.server.status.good.desc", new Object[0]), STATUS_GOOD);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        DartFeedbackBuilder builder = DartFeedbackBuilder.getFeedbackBuilder();
        if (builder.showQuery(null)) {
            builder.sendFeedback(project, null, null);
        }
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (AnalysisServerStatusAction.isApplicable(project)) {
            presentation.setEnabledAndVisible(true);
            AnalysisServerStatusAction.updateStatus(project, presentation);
        } else {
            presentation.setEnabledAndVisible(false);
        }
    }

    private static void updateStatus(@NotNull Project project, @NotNull Presentation presentation) {
        String statusDesc;
        String statusText;
        Icon statusIcon;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/errorTreeView/AnalysisServerStatusAction", "updateStatus"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/jetbrains/lang/dart/ide/errorTreeView/AnalysisServerStatusAction", "updateStatus"));
        }
        DartAnalysisServerService das = DartAnalysisServerService.getInstance(project);
        if (das.isServerProcessActive()) {
            if (das.isServerResponsive()) {
                statusIcon = STATUS_GOOD;
                statusText = DartBundle.message("analysis.server.status.good.text", new Object[0]);
                statusDesc = DartBundle.message("analysis.server.status.good.desc", new Object[0]);
            } else {
                statusIcon = STATUS_UNKNOWN;
                statusText = DartBundle.message("analysis.server.status.unknown.text", new Object[0]);
                statusDesc = DartBundle.message("analysis.server.status.unknown.desc", new Object[0]);
            }
        } else {
            statusIcon = STATUS_BAD;
            statusText = DartBundle.message("analysis.server.status.bad.text", new Object[0]);
            statusDesc = DartBundle.message("analysis.server.status.bad.desc", new Object[0]);
        }
        presentation.setIcon(statusIcon);
        presentation.setText(statusText);
        presentation.setDescription(statusDesc);
    }

    private static boolean isApplicable(@Nullable Project project) {
        return project != null && ToolWindowManager.getInstance((Project)project).getToolWindow(DartProblemsView.TOOLWINDOW_ID) != null;
    }
}

