/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.errorTreeView;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.JBColor;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DartFeedbackBuilder {
    public static final int MAX_URL_LENGTH = 1900;
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Dart Analyzer Error", NotificationDisplayType.NONE, true);
    private static ExtensionPointName<DartFeedbackBuilder> EP_NAME = ExtensionPointName.create((String)"Dart.feedbackBuilder");

    @NotNull
    public static DartFeedbackBuilder getFeedbackBuilder() {
        DartFeedbackBuilder[] builders = (DartFeedbackBuilder[])EP_NAME.getExtensions();
        assert (builders.length > 0);
        DartFeedbackBuilder dartFeedbackBuilder = builders[0];
        if (dartFeedbackBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/errorTreeView/DartFeedbackBuilder", "getFeedbackBuilder"));
        }
        return dartFeedbackBuilder;
    }

    public String title() {
        return "Open Browser";
    }

    public abstract String prompt();

    public String label() {
        return "Send feedback";
    }

    public abstract void sendFeedback(@NotNull Project var1, @Nullable String var2, @Nullable String var3);

    public boolean showQuery(@Nullable String message) {
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)this.title(), (String)(message == null ? this.prompt() : message + "\n" + this.prompt())).icon(Messages.getQuestionIcon())).yesText(this.label())).show() == 0;
    }

    public void showNotification(@NotNull String message, final @NotNull Project project, final @Nullable String errorMessage, final @Nullable String debugLog) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/lang/dart/ide/errorTreeView/DartFeedbackBuilder", "showNotification"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/errorTreeView/DartFeedbackBuilder", "showNotification"));
        }
        String content = message + "<br><a href=\"\">" + this.prompt() + "</a>";
        NotificationListener.Adapter listener = new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/jetbrains/lang/dart/ide/errorTreeView/DartFeedbackBuilder$1", "hyperlinkActivated"));
                }
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/lang/dart/ide/errorTreeView/DartFeedbackBuilder$1", "hyperlinkActivated"));
                }
                notification.expire();
                DartFeedbackBuilder.this.sendFeedback(project, errorMessage, debugLog);
            }
        };
        Notification notification = NOTIFICATION_GROUP.createNotification(NOTIFICATION_GROUP.getDisplayId(), content, NotificationType.ERROR, (NotificationListener)listener);
        notification.notify(project);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/errorTreeView/DartFeedbackBuilder", "lambda$showNotification$0"));
            }
            DartFeedbackBuilder.showErrorNotification(notification, project);
        }, ModalityState.NON_MODAL, project.getDisposed());
    }

    private static void showErrorNotification(@NotNull Notification notification, @NotNull Project project) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/jetbrains/lang/dart/ide/errorTreeView/DartFeedbackBuilder", "showErrorNotification"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/errorTreeView/DartFeedbackBuilder", "showErrorNotification"));
        }
        IdeFrame myFrame = WindowManager.getInstance().getIdeFrame(project);
        BalloonLayout layout = myFrame.getBalloonLayout();
        assert (layout != null);
        BalloonLayoutData layoutData = BalloonLayoutData.createEmpty();
        layoutData.fadeoutTime = 5000L;
        layoutData.fillColor = new JBColor(16115431, 5848385);
        layoutData.borderColor = new JBColor(14723241, 7554379);
        Balloon balloon = NotificationsManagerImpl.createBalloon((IdeFrame)myFrame, (Notification)notification, (boolean)false, (boolean)false, (Ref)new Ref((Object)layoutData), (Disposable)project);
        layout.add(balloon);
    }
}

