/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.errorTreeView;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblem;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsFilterForm;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsTableModel;
import com.jetbrains.lang.dart.util.DartBuildFileUtil;
import com.jetbrains.lang.dart.util.PubspecYamlUtil;
import javax.swing.RowFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartProblemsFilter
extends RowFilter<DartProblemsTableModel, Integer> {
    private static final boolean SHOW_ERRORS_DEFAULT = true;
    private static final boolean SHOW_WARNINGS_DEFAULT = true;
    private static final boolean SHOW_HINTS_DEFAULT = true;
    private static final FileFilterMode FILE_FILTER_MODE_DEFAULT = FileFilterMode.All;
    @NotNull
    private final Project myProject;
    private boolean myShowErrors;
    private boolean myShowWarnings;
    private boolean myShowHints;
    private FileFilterMode myFileFilterMode;
    @Nullable
    private VirtualFile myCurrentFile;
    private boolean myDartPackageRootUpToDate;
    @Nullable
    private VirtualFile myCurrentDartPackageRoot;
    private boolean myContentRootUpToDate;
    @Nullable
    private VirtualFile myCurrentContentRoot;

    public DartProblemsFilter(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsFilter", "<init>"));
        }
        this.myDartPackageRootUpToDate = false;
        this.myContentRootUpToDate = false;
        this.myProject = project;
        this.resetAllFilters();
    }

    public void resetAllFilters() {
        this.myShowErrors = true;
        this.myShowWarnings = true;
        this.myShowHints = true;
        this.myFileFilterMode = FILE_FILTER_MODE_DEFAULT;
        assert (!this.areFiltersApplied());
    }

    public void updateFromUI(@NotNull DartProblemsFilterForm form) {
        if (form == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "form", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsFilter", "updateFromUI"));
        }
        this.myShowErrors = form.isShowErrors();
        this.myShowWarnings = form.isShowWarnings();
        this.myShowHints = form.isShowHints();
        this.myFileFilterMode = form.getFileFilterMode();
    }

    public boolean areFiltersApplied() {
        if (!this.myShowErrors) {
            return true;
        }
        if (!this.myShowWarnings) {
            return true;
        }
        if (!this.myShowHints) {
            return true;
        }
        return this.myFileFilterMode != FILE_FILTER_MODE_DEFAULT;
    }

    public boolean setCurrentFile(@Nullable VirtualFile file) {
        if (Comparing.equal((Object)this.myCurrentFile, (Object)file)) {
            return false;
        }
        this.myCurrentFile = file;
        this.myDartPackageRootUpToDate = false;
        this.myContentRootUpToDate = false;
        return true;
    }

    public boolean isShowErrors() {
        return this.myShowErrors;
    }

    public boolean isShowWarnings() {
        return this.myShowWarnings;
    }

    public boolean isShowHints() {
        return this.myShowHints;
    }

    public FileFilterMode getFileFilterMode() {
        return this.myFileFilterMode;
    }

    @Override
    public boolean include(@NotNull RowFilter.Entry<? extends DartProblemsTableModel, ? extends Integer> entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsFilter", "include"));
        }
        return this.include((DartProblem)entry.getModel().getItem(entry.getIdentifier()));
    }

    public boolean include(@NotNull DartProblem problem) {
        if (problem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problem", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsFilter", "include"));
        }
        if (!this.myShowErrors && "ERROR".equals(problem.getSeverity())) {
            return false;
        }
        if (!this.myShowWarnings && "WARNING".equals(problem.getSeverity())) {
            return false;
        }
        if (!this.myShowHints && "INFO".equals(problem.getSeverity())) {
            return false;
        }
        if (!(this.myFileFilterMode != FileFilterMode.File || this.myCurrentFile != null && this.myCurrentFile.equals(problem.getFile()))) {
            return false;
        }
        if (this.myFileFilterMode == FileFilterMode.Directory) {
            if (this.myCurrentFile == null) {
                return false;
            }
            VirtualFile parent = this.myCurrentFile.getParent();
            VirtualFile child = problem.getFile();
            if (child != null && parent != null && !child.getPath().startsWith(parent.getPath() + "/")) {
                return false;
            }
        }
        if (this.myFileFilterMode == FileFilterMode.DartPackage) {
            this.ensurePackageRootUpToDate();
            if (this.myCurrentDartPackageRoot == null || !this.myCurrentDartPackageRoot.equals(problem.getPackageRoot())) {
                return false;
            }
        }
        if (this.myFileFilterMode == FileFilterMode.ContentRoot) {
            this.ensureContentRootUpToDate();
            if (this.myCurrentContentRoot == null || !this.myCurrentContentRoot.equals(problem.getContentRoot())) {
                return false;
            }
        }
        return true;
    }

    private void ensurePackageRootUpToDate() {
        VirtualFile packageRoot;
        if (this.myDartPackageRootUpToDate) {
            return;
        }
        if (this.myCurrentFile == null) {
            packageRoot = null;
        } else {
            VirtualFile contentRoot;
            VirtualFile pubspec;
            VirtualFile virtualFile = pubspec = Registry.is((String)"dart.projects.without.pubspec", (boolean)false) ? DartBuildFileUtil.findPackageRootBuildFile(this.myProject, this.myCurrentFile) : PubspecYamlUtil.findPubspecYamlFile(this.myProject, this.myCurrentFile);
            packageRoot = pubspec == null ? ((contentRoot = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getContentRootForFile(this.myCurrentFile, false)) == null ? null : contentRoot) : pubspec.getParent();
        }
        this.myCurrentDartPackageRoot = packageRoot;
        this.myDartPackageRootUpToDate = true;
    }

    private void ensureContentRootUpToDate() {
        if (this.myContentRootUpToDate) {
            return;
        }
        this.myCurrentContentRoot = this.myCurrentFile == null ? null : ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getContentRootForFile(this.myCurrentFile, false);
        this.myContentRootUpToDate = true;
    }

    public static enum FileFilterMode {
        All,
        ContentRoot,
        DartPackage,
        Directory,
        File;

    }
}

