/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.errorTreeView;

import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class DartProblemsFilterForm {
    private JPanel myMainPanel;
    private JBCheckBox myErrorsCheckBox;
    private JBCheckBox myWarningsCheckBox;
    private JBCheckBox myHintsCheckBox;
    private JBRadioButton myWholeProjectRadioButton;
    private JBRadioButton myCurrentContentRootRadioButton;
    private JBRadioButton myCurrentDartPackageRadioButton;
    private JBRadioButton myCurrentDirectoryRadioButton;
    private JBRadioButton myCurrentFileRadioButton;
    private HoverHyperlinkLabel myResetFilterHyperlink;
    private List<FilterListener> myListeners;

    public DartProblemsFilterForm() {
        this.$$$setupUI$$$();
        this.myListeners = new ArrayList<FilterListener>();
    }

    private void createUIComponents() {
        this.myResetFilterHyperlink = new HoverHyperlinkLabel(DartBundle.message("reset.filter", new Object[0]));
        this.myResetFilterHyperlink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                DartProblemsFilterForm.this.myListeners.forEach(FilterListener::filtersResetRequested);
            }
        });
    }

    public void reset(@NotNull DartProblemsFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsFilterForm", "reset"));
        }
        this.myErrorsCheckBox.setSelected(filter.isShowErrors());
        this.myWarningsCheckBox.setSelected(filter.isShowWarnings());
        this.myHintsCheckBox.setSelected(filter.isShowHints());
        if (filter.getFileFilterMode() == DartProblemsFilter.FileFilterMode.File) {
            this.myCurrentFileRadioButton.setSelected(true);
        } else if (filter.getFileFilterMode() == DartProblemsFilter.FileFilterMode.Directory) {
            this.myCurrentDirectoryRadioButton.setSelected(true);
        } else if (filter.getFileFilterMode() == DartProblemsFilter.FileFilterMode.DartPackage) {
            this.myCurrentDartPackageRadioButton.setSelected(true);
        } else if (filter.getFileFilterMode() == DartProblemsFilter.FileFilterMode.ContentRoot) {
            this.myCurrentContentRootRadioButton.setSelected(true);
        } else {
            this.myWholeProjectRadioButton.setSelected(true);
        }
    }

    public void addListener(final @NotNull FilterListener filterListener) {
        if (filterListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterListener", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsFilterForm", "addListener"));
        }
        this.myListeners.add(filterListener);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                filterListener.filtersChanged();
            }
        };
        this.myErrorsCheckBox.addActionListener(listener);
        this.myWarningsCheckBox.addActionListener(listener);
        this.myHintsCheckBox.addActionListener(listener);
        this.myWholeProjectRadioButton.addActionListener(listener);
        this.myCurrentContentRootRadioButton.addActionListener(listener);
        this.myCurrentDartPackageRadioButton.addActionListener(listener);
        this.myCurrentDirectoryRadioButton.addActionListener(listener);
        this.myCurrentFileRadioButton.addActionListener(listener);
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public boolean isShowErrors() {
        return this.myErrorsCheckBox.isSelected();
    }

    public boolean isShowWarnings() {
        return this.myWarningsCheckBox.isSelected();
    }

    public boolean isShowHints() {
        return this.myHintsCheckBox.isSelected();
    }

    public DartProblemsFilter.FileFilterMode getFileFilterMode() {
        if (this.myCurrentFileRadioButton.isSelected()) {
            return DartProblemsFilter.FileFilterMode.File;
        }
        if (this.myCurrentDirectoryRadioButton.isSelected()) {
            return DartProblemsFilter.FileFilterMode.Directory;
        }
        if (this.myCurrentDartPackageRadioButton.isSelected()) {
            return DartProblemsFilter.FileFilterMode.DartPackage;
        }
        if (this.myCurrentContentRootRadioButton.isSelected()) {
            return DartProblemsFilter.FileFilterMode.ContentRoot;
        }
        return DartProblemsFilter.FileFilterMode.All;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBRadioButton jBRadioButton;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JBRadioButton jBRadioButton2;
        JBRadioButton jBRadioButton3;
        JBRadioButton jBRadioButton4;
        JBRadioButton jBRadioButton5;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 5, new Insets(5, 10, 10, 5), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        HoverHyperlinkLabel hoverHyperlinkLabel = this.myResetFilterHyperlink;
        this.$$$loadLabelText$$$((JLabel)hoverHyperlinkLabel, ResourceBundle.getBundle("com/jetbrains/lang/dart/DartBundle").getString("reset.filter"));
        jPanel.add((Component)hoverHyperlinkLabel, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myWholeProjectRadioButton = jBRadioButton5 = new JBRadioButton();
        jBRadioButton5.setMargin(new Insets(0, 2, 0, 2));
        jBRadioButton5.setText("Whole project");
        jBRadioButton5.setMnemonic('O');
        jBRadioButton5.setDisplayedMnemonicIndex(2);
        jPanel.add((Component)jBRadioButton5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCurrentContentRootRadioButton = jBRadioButton4 = new JBRadioButton();
        jBRadioButton4.setMargin(new Insets(0, 2, 0, 2));
        jBRadioButton4.setText("Current content root");
        jBRadioButton4.setMnemonic('C');
        jBRadioButton4.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jBRadioButton4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCurrentDirectoryRadioButton = jBRadioButton3 = new JBRadioButton();
        jBRadioButton3.setMargin(new Insets(0, 2, 0, 2));
        jBRadioButton3.setText("Current directory");
        jBRadioButton3.setMnemonic('D');
        jBRadioButton3.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jBRadioButton3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCurrentFileRadioButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setMargin(new Insets(0, 2, 0, 2));
        jBRadioButton2.setText("Current file");
        jBRadioButton2.setMnemonic('F');
        jBRadioButton2.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jBRadioButton2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myErrorsCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Errors");
        jBCheckBox3.setMnemonic('E');
        jBCheckBox3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBCheckBox3, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWarningsCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Warnings");
        jBCheckBox2.setMnemonic('W');
        jBCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBCheckBox2, new GridConstraints(2, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Files");
        jPanel.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Severity");
        jPanel.add((Component)titledSeparator2, new GridConstraints(0, 2, 1, 2, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 15), new Dimension(-1, 15), new Dimension(-1, 15)));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(1, 1, 1, 1, 0, 1, 0, 1, new Dimension(15, -1), new Dimension(15, -1), new Dimension(15, -1)));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(1, 3, 1, 1, 0, 1, 0, 1, new Dimension(30, -1), new Dimension(30, -1), new Dimension(30, -1)));
        Spacer spacer5 = new Spacer();
        jPanel.add((Component)spacer5, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myCurrentDartPackageRadioButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setMargin(new Insets(0, 2, 0, 2));
        jBRadioButton.setText("Current Dart package");
        jBRadioButton.setMnemonic('P');
        jBRadioButton.setDisplayedMnemonicIndex(13);
        jPanel.add((Component)jBRadioButton, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHintsCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Hints");
        jBCheckBox.setMnemonic('H');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBCheckBox, new GridConstraints(3, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton3);
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton5);
        buttonGroup.add((AbstractButton)jBRadioButton4);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    static interface FilterListener {
        public void filtersChanged();

        public void filtersResetRequested();
    }
}

