/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.errorTreeView;

import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerMessages;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.errorTreeView.AnalysisServerDiagnosticsAction;
import com.jetbrains.lang.dart.ide.errorTreeView.AnalysisServerStatusAction;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsFilter;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsViewPanel;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsViewSettings;
import gnu.trove.THashMap;
import icons.DartIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.dartlang.analysis.server.protocol.AnalysisError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DartProblemsView", storages={@Storage(value="$WORKSPACE_FILE$")})
public class DartProblemsView
implements PersistentStateComponent<DartProblemsViewSettings> {
    public static final String TOOLWINDOW_ID = DartBundle.message("dart.analysis.tool.window", new Object[0]);
    private static final int TABLE_REFRESH_PERIOD = 300;
    private final Project myProject;
    private final DartProblemsFilter myFilter;
    private DartProblemsViewPanel myPanel;
    private final Object myLock;
    private final Map<String, List<AnalysisError>> myScheduledFilePathToErrors;
    private final Alarm myAlarm;
    private DartProblemsViewSettings mySettings;
    private ToolWindow myToolWindow;
    private Icon myCurrentIcon;
    private boolean myAnalysisIsBusy;
    private int myFilesWithErrorsHash;
    private final Runnable myUpdateRunnable;

    public DartProblemsView(@NotNull Project project, @NotNull ToolWindowManager toolWindowManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsView", "<init>"));
        }
        if (toolWindowManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowManager", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsView", "<init>"));
        }
        this.myLock = new Object();
        this.myScheduledFilePathToErrors = new THashMap();
        this.mySettings = new DartProblemsViewSettings();
        this.myUpdateRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                THashMap filePathToErrors;
                if ("ProjectPane".equals(ProjectView.getInstance((Project)DartProblemsView.this.myProject).getCurrentViewId())) {
                    int hash = DartAnalysisServerService.getInstance(DartProblemsView.this.myProject).getFilePathsWithErrorsHash();
                    if (DartProblemsView.this.myFilesWithErrorsHash != hash) {
                        DartProblemsView.this.myFilesWithErrorsHash = hash;
                        ProjectView.getInstance((Project)DartProblemsView.this.myProject).refresh();
                    }
                }
                Object object = DartProblemsView.this.myLock;
                synchronized (object) {
                    filePathToErrors = new THashMap(DartProblemsView.this.myScheduledFilePathToErrors);
                    DartProblemsView.this.myScheduledFilePathToErrors.clear();
                }
                DartProblemsView.this.myPanel.setErrors((Map<String, List<AnalysisError>>)filePathToErrors);
            }
        };
        this.myProject = project;
        this.myFilter = new DartProblemsFilter(project);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)project);
        Disposer.register((Disposable)project, (Disposable)this.myAlarm);
        UIUtil.invokeLaterIfNeeded(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsView", "lambda$new$1"));
            }
            if (toolWindowManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowManager", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsView", "lambda$new$1"));
            }
            if (project.isDisposed()) {
                return;
            }
            this.myPanel = new DartProblemsViewPanel(project, this.myFilter, this.mySettings);
            this.myToolWindow = toolWindowManager.registerToolWindow(TOOLWINDOW_ID, false, ToolWindowAnchor.BOTTOM, (Disposable)project, true);
            this.myCurrentIcon = DartIcons.Dart_13;
            this.updateIcon();
            final Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)((Object)this.myPanel), "", false);
            this.myToolWindow.getContentManager().addContent(content);
            ToolWindowEx toolWindowEx = (ToolWindowEx)this.myToolWindow;
            toolWindowEx.setTitleActions(new AnAction[]{new AnalysisServerStatusAction()});
            ArrayList<AnalysisServerDiagnosticsAction> gearActions = new ArrayList<AnalysisServerDiagnosticsAction>();
            gearActions.add(new AnalysisServerDiagnosticsAction());
            toolWindowEx.setAdditionalGearActions((ActionGroup)new DefaultActionGroup(gearActions));
            this.myPanel.setToolWindowUpdater(new ToolWindowUpdater(){

                @Override
                public void setIcon(@NotNull Icon icon) {
                    if (icon == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsView$2", "setIcon"));
                    }
                    DartProblemsView.this.myCurrentIcon = icon;
                    DartProblemsView.this.updateIcon();
                }

                @Override
                public void setHeaderText(@NotNull String headerText) {
                    if (headerText == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerText", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsView$2", "setHeaderText"));
                    }
                    content.setDisplayName(headerText);
                }
            });
            if (PropertiesComponent.getInstance((Project)project).getBoolean("dart.analysis.tool.window.force.activate", true)) {
                PropertiesComponent.getInstance((Project)project).setValue("dart.analysis.tool.window.force.activate", false, true);
                this.myToolWindow.activate(null, false);
            }
            Disposer.register((Disposable)project, () -> this.myToolWindow.getContentManager().removeAllContents(true));
        });
        project.getMessageBus().connect().subscribe(DartAnalysisServerMessages.DART_ANALYSIS_TOPIC, (Object)new DartAnalysisServerMessages.DartAnalysisNotifier(){

            @Override
            public void analysisStarted() {
                DartProblemsView.this.myAnalysisIsBusy = true;
                UIUtil.invokeLaterIfNeeded(() -> DartProblemsView.this.updateIcon());
            }

            @Override
            public void analysisFinished() {
                DartProblemsView.this.myAnalysisIsBusy = false;
                UIUtil.invokeLaterIfNeeded(() -> DartProblemsView.this.updateIcon());
            }
        });
    }

    void updateIcon() {
        if (this.myAnalysisIsBusy) {
            this.myToolWindow.setIcon(ExecutionUtil.getLiveIndicator((Icon)this.myCurrentIcon));
        } else {
            this.myToolWindow.setIcon(this.myCurrentIcon);
        }
    }

    public static DartProblemsView getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsView", "getInstance"));
        }
        return (DartProblemsView)ServiceManager.getService((Project)project, DartProblemsView.class);
    }

    public DartProblemsViewSettings getState() {
        return this.mySettings;
    }

    public void loadState(DartProblemsViewSettings state) {
        this.mySettings = state;
        if (this.myPanel != null) {
            this.myPanel.updateFromSettings(this.mySettings);
        }
    }

    public void setCurrentFile(@Nullable VirtualFile file) {
        if (this.myFilter.setCurrentFile(file) && this.myFilter.getFileFilterMode() != DartProblemsFilter.FileFilterMode.All && this.myPanel != null) {
            this.myPanel.fireGroupingOrFilterChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateErrorsForFile(@NotNull String filePath, @NotNull List<AnalysisError> errors) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsView", "updateErrorsForFile"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsView", "updateErrorsForFile"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myScheduledFilePathToErrors.isEmpty()) {
                this.myAlarm.addRequest(this.myUpdateRunnable, 300, ModalityState.NON_MODAL);
            }
            this.myScheduledFilePathToErrors.put(filePath, errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ProjectView.getInstance((Project)this.myProject).refresh();
        Object object = this.myLock;
        synchronized (object) {
            this.myAlarm.cancelAllRequests();
            this.myScheduledFilePathToErrors.clear();
        }
        this.myPanel.clearAll();
    }

    static interface ToolWindowUpdater {
        public void setIcon(@NotNull Icon var1);

        public void setHeaderText(@NotNull String var1);
    }
}

