/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.errorTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.table.TableView;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblem;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsFilter;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsFilterForm;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsTableModel;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsView;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsViewSettings;
import icons.DartIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultRowSorter;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.table.JTableHeader;
import org.dartlang.analysis.server.protocol.AnalysisError;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartProblemsViewPanel
extends SimpleToolWindowPanel
implements DataProvider,
CopyProvider {
    private static final long DEFAULT_SERVER_WAIT_MILLIS = 5000L;
    private static final LayeredIcon DART_ERRORS_ICON = new LayeredIcon(2);
    private static final LayeredIcon DART_WARNINGS_ICON;
    @NotNull
    private final Project myProject;
    @NotNull
    private final TableView<DartProblem> myTable;
    @NotNull
    private DartProblemsViewSettings mySettings;
    @NotNull
    private final DartProblemsFilter myFilter;
    private DartProblemsView.ToolWindowUpdater myToolWindowUpdater;

    public DartProblemsViewPanel(@NotNull Project project, @NotNull DartProblemsFilter filter, @NotNull DartProblemsViewSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsViewPanel", "<init>"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsViewPanel", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsViewPanel", "<init>"));
        }
        super(false, true);
        this.myProject = project;
        this.myFilter = filter;
        this.mySettings = settings;
        this.myTable = this.createTable();
        this.setToolbar(this.createToolbar());
        this.setContent(this.createCenterPanel());
        DartAnalysisServerService.getInstance((Project)project).maxMillisToWaitForServerResponse = 5000L;
    }

    @NotNull
    private TableView<DartProblem> createTable() {
        TableView table = new TableView((ListTableModel)new DartProblemsTableModel(this.myProject, this.myFilter));
        table.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DartProblemsViewPanel.this.navigate(false);
                }
            }
        });
        EditSourceOnDoubleClickHandler.install((JTable)table);
        table.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                DartProblemsViewPanel.this.popupInvoked(comp, x, y);
            }
        });
        ((DefaultRowSorter)table.getRowSorter()).setRowFilter(this.myFilter);
        table.getRowSorter().addRowSorterListener(e -> {
            List<RowSorter.SortKey> sortKeys = this.myTable.getRowSorter().getSortKeys();
            assert (sortKeys.size() == 1) : sortKeys;
            ((DartProblemsTableModel)((Object)((Object)this.myTable.getModel()))).setSortKey(sortKeys.get(0));
        });
        new TableSpeedSearch((JTable)table, object -> object instanceof DartProblem ? ((DartProblem)object).getErrorMessage() + " " + ((DartProblem)object).getPresentableLocation() : "");
        table.setShowVerticalLines(false);
        table.setShowHorizontalLines(false);
        table.setStriped(true);
        table.setRowHeight(table.getRowHeight() + JBUI.scale((int)4));
        JTableHeader tableHeader = table.getTableHeader();
        tableHeader.setPreferredSize(new Dimension(0, table.getRowHeight()));
        TableView tableView = table;
        if (tableView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsViewPanel", "createTable"));
        }
        return tableView;
    }

    private void popupInvoked(Component component, int x, int y) {
        DefaultActionGroup group = new DefaultActionGroup();
        if (this.getData(CommonDataKeys.NAVIGATABLE.getName()) != null) {
            group.add(ActionManager.getInstance().getAction("EditSource"));
        }
        group.add(ActionManager.getInstance().getAction("$Copy"));
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("toolbar", (ActionGroup)group);
        menu.getComponent().show(component, x, y);
    }

    @NotNull
    private JComponent createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        DartProblemsViewPanel.addReanalyzeActions(group);
        group.addSeparator();
        this.addAutoScrollToSourceAction(group);
        this.addGroupBySeverityAction(group);
        group.addAction((AnAction)new FilterProblemsAction());
        group.addSeparator();
        group.addAction((AnAction)new ContextHelpAction("reference.toolWindow.DartAnalysis"));
        JComponent jComponent = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)group, false).getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsViewPanel", "createToolbar"));
        }
        return jComponent;
    }

    @NotNull
    private JPanel createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)ScrollPaneFactory.createScrollPane(this.myTable), "Center");
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsViewPanel", "createCenterPanel"));
        }
        return jPanel;
    }

    private void updateStatusDescription() {
        if (this.myToolWindowUpdater != null) {
            DartProblemsTableModel model = (DartProblemsTableModel)((Object)this.myTable.getModel());
            this.myToolWindowUpdater.setHeaderText(model.getStatusText());
            this.myToolWindowUpdater.setIcon((Icon)(model.hasErrors() ? DART_ERRORS_ICON : (model.hasWarnings() ? DART_WARNINGS_ICON : DartIcons.Dart_13)));
        }
    }

    private static void addReanalyzeActions(@NotNull DefaultActionGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsViewPanel", "addReanalyzeActions"));
        }
        AnAction restartAction = ActionManager.getInstance().getAction("Dart.Restart.Analysis.Server");
        if (restartAction != null) {
            group.add(restartAction);
        }
    }

    private void addAutoScrollToSourceAction(@NotNull DefaultActionGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsViewPanel", "addAutoScrollToSourceAction"));
        }
        AutoScrollToSourceHandler autoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return ((DartProblemsViewPanel)DartProblemsViewPanel.this).mySettings.autoScrollToSource;
            }

            protected void setAutoScrollMode(boolean autoScrollToSource) {
                ((DartProblemsViewPanel)DartProblemsViewPanel.this).mySettings.autoScrollToSource = autoScrollToSource;
            }
        };
        autoScrollToSourceHandler.install(this.myTable);
        group.addAction((AnAction)autoScrollToSourceHandler.createToggleAction());
    }

    private void addGroupBySeverityAction(@NotNull DefaultActionGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsViewPanel", "addGroupBySeverityAction"));
        }
        ToggleAction action = new ToggleAction(DartBundle.message("group.by.severity", new Object[0]), DartBundle.message("group.by.severity.description", new Object[0]), AllIcons.Nodes.SortBySeverity){

            public boolean isSelected(AnActionEvent e) {
                return ((DartProblemsTableModel)((Object)DartProblemsViewPanel.this.myTable.getModel())).isGroupBySeverity();
            }

            public void setSelected(AnActionEvent e, boolean groupBySeverity) {
                ((DartProblemsTableModel)((Object)DartProblemsViewPanel.this.myTable.getModel())).setGroupBySeverity(groupBySeverity);
                DartProblemsViewPanel.this.fireGroupingOrFilterChanged();
            }
        };
        group.addAction((AnAction)action);
    }

    void fireGroupingOrFilterChanged() {
        this.myTable.getRowSorter().allRowsChanged();
        ((DartProblemsTableModel)((Object)this.myTable.getModel())).onFilterChanged();
        this.updateStatusDescription();
    }

    private void showFiltersPopup() {
        final DartProblemsFilterForm form = new DartProblemsFilterForm();
        form.reset(this.myFilter);
        form.addListener(new DartProblemsFilterForm.FilterListener(){

            @Override
            public void filtersChanged() {
                DartProblemsViewPanel.this.myFilter.updateFromUI(form);
                DartProblemsViewPanel.this.fireGroupingOrFilterChanged();
            }

            @Override
            public void filtersResetRequested() {
                DartProblemsViewPanel.this.myFilter.resetAllFilters();
                form.reset(DartProblemsViewPanel.this.myFilter);
                DartProblemsViewPanel.this.fireGroupingOrFilterChanged();
            }
        });
        Rectangle visibleRect = this.myTable.getVisibleRect();
        Point tableTopLeft = new Point(this.myTable.getLocationOnScreen().x + visibleRect.x, this.myTable.getLocationOnScreen().y + visibleRect.y);
        JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)form.getMainPanel(), (JComponent)form.getMainPanel()).setProject(this.myProject).setTitle("Dart Problems Filter").setMovable(true).setRequestFocus(true).createPopup().show(RelativePoint.fromScreen((Point)tableTopLeft));
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsViewPanel", "isCopyVisible"));
        }
        return true;
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsViewPanel", "isCopyEnabled"));
        }
        return this.myTable.getSelectedObject() != null;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsViewPanel", "performCopy"));
        }
        List selectedObjects = this.myTable.getSelectedObjects();
        String s = StringUtil.join((Collection)selectedObjects, problem -> problem.getSeverity().toLowerCase() + ": " + problem.getErrorMessage() + " (" + problem.getCode() + " at " + problem.getPresentableLocation() + ")", (String)"\n");
        if (!s.isEmpty()) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(s));
        }
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return this.createNavigatable();
        }
        return null;
    }

    @Nullable
    private Navigatable createNavigatable() {
        VirtualFile file;
        DartProblem problem = (DartProblem)this.myTable.getSelectedObject();
        if (problem != null && (file = LocalFileSystem.getInstance().findFileByPath(problem.getSystemIndependentPath())) != null) {
            OpenFileDescriptor navigatable = new OpenFileDescriptor(this.myProject, file, problem.getOffset());
            navigatable.setScrollType(ScrollType.MAKE_VISIBLE);
            return navigatable;
        }
        return null;
    }

    private void navigate(boolean requestFocus) {
        Navigatable navigatable = this.createNavigatable();
        if (navigatable != null && navigatable.canNavigateToSource()) {
            navigatable.navigate(requestFocus);
        }
    }

    public void setErrors(@NotNull Map<String, List<AnalysisError>> filePathToErrors) {
        DartProblem oldSelectedProblem;
        if (filePathToErrors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePathToErrors", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsViewPanel", "setErrors"));
        }
        DartProblemsTableModel model = (DartProblemsTableModel)((Object)this.myTable.getModel());
        DartProblem updatedSelectedProblem = model.setErrorsAndReturnReplacementForSelection(filePathToErrors, oldSelectedProblem = (DartProblem)this.myTable.getSelectedObject());
        if (updatedSelectedProblem != null) {
            this.myTable.setSelection(Collections.singletonList(updatedSelectedProblem));
        }
        this.updateStatusDescription();
    }

    public void clearAll() {
        ((DartProblemsTableModel)((Object)this.myTable.getModel())).removeAll();
        this.updateStatusDescription();
    }

    void setToolWindowUpdater(@NotNull DartProblemsView.ToolWindowUpdater toolWindowUpdater) {
        if (toolWindowUpdater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowUpdater", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsViewPanel", "setToolWindowUpdater"));
        }
        this.myToolWindowUpdater = toolWindowUpdater;
    }

    void updateFromSettings(DartProblemsViewSettings settings) {
        this.mySettings = settings;
    }

    static {
        DART_ERRORS_ICON.setIcon(DartIcons.Dart_13, 0);
        DART_ERRORS_ICON.setIcon(AllIcons.Ide.ErrorPoint, 1, 6);
        DART_WARNINGS_ICON = new LayeredIcon(2);
        DART_WARNINGS_ICON.setIcon(DartIcons.Dart_13, 0);
        DART_WARNINGS_ICON.setIcon(DartIcons.Warning_point, 1, 6);
    }

    private class FilterProblemsAction
    extends DumbAwareAction
    implements Toggleable {
        public FilterProblemsAction() {
            super(DartBundle.message("filter.problems", new Object[0]), DartBundle.message("filter.problems.description", new Object[0]), AllIcons.General.Filter);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().putClientProperty("selected", (Object)DartProblemsViewPanel.this.myFilter.areFiltersApplied());
        }

        public void actionPerformed(AnActionEvent e) {
            DartProblemsViewPanel.this.showFiltersPopup();
        }
    }
}

