/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.errorTreeView;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.actions.SendFeedbackAction;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.errorTreeView.DartFeedbackBuilder;
import com.jetbrains.lang.dart.sdk.DartSdk;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultDartFeedbackBuilder
extends DartFeedbackBuilder {
    @Override
    public String prompt() {
        return "Open issue submission form";
    }

    @Override
    public void sendFeedback(@NotNull Project project, @Nullable String errorMessage, @Nullable String serverLog) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/errorTreeView/DefaultDartFeedbackBuilder", "sendFeedback"));
        }
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        boolean eap = appInfo.isEAP();
        String ijBuild = eap ? appInfo.getBuild().asStringWithoutProductCode() : appInfo.getBuild().asString();
        String sdkVsn = this.getSdkVersion(project);
        String platDescr = StringUtil.replace((String)SendFeedbackAction.getDescription(), (String)";", (String)" ").trim();
        String template = DartBundle.message("dart.feedback.url.template", ijBuild, sdkVsn, platDescr);
        if (errorMessage != null) {
            errorMessage = "```\n" + errorMessage + "```";
            try {
                File file = FileUtil.createTempFile((String)"report", (String)".txt");
                FileUtil.writeToFile((File)file, (String)errorMessage);
                if (serverLog != null) {
                    FileUtil.writeToFile((File)file, (String)("\n\n" + serverLog), (boolean)true);
                }
                String potentialTemplate = template + "\n\n" + DartBundle.message("dart.error.file.instructions", file.getAbsolutePath()) + "\n\n" + errorMessage;
                template = potentialTemplate.substring(0, Math.min(potentialTemplate.length(), 1900));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        DefaultDartFeedbackBuilder.openBrowserOnFeedbackForm(template, project);
    }

    public static void openBrowserOnFeedbackForm(@NotNull String urlTemplate, @Nullable Project project) {
        if (urlTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlTemplate", "com/jetbrains/lang/dart/ide/errorTreeView/DefaultDartFeedbackBuilder", "openBrowserOnFeedbackForm"));
        }
        BrowserUtil.browse((String)urlTemplate, (Project)project);
    }

    protected String getSdkVersion(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/errorTreeView/DefaultDartFeedbackBuilder", "getSdkVersion"));
        }
        DartSdk sdk = DartSdk.getDartSdk(project);
        return sdk == null ? "<NO SDK>" : sdk.getVersion();
    }
}

