/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.findUsages;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.findUsages.ReadActionConsumer;
import com.jetbrains.lang.dart.psi.DartReference;
import org.dartlang.analysis.server.protocol.Location;
import org.dartlang.analysis.server.protocol.SearchResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartServerFindUsagesHandler
extends FindUsagesHandler {
    public DartServerFindUsagesHandler(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/findUsages/DartServerFindUsagesHandler", "<init>"));
        }
        super(DartServerFindUsagesHandler.mayBeChangeToNameIdentifier(element));
    }

    @NotNull
    private static PsiElement mayBeChangeToNameIdentifier(@NotNull PsiElement element) {
        PsiElement nameIdentifier;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/findUsages/DartServerFindUsagesHandler", "mayBeChangeToNameIdentifier"));
        }
        if (element instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)element).getNameIdentifier()) != null) {
            PsiElement psiElement = nameIdentifier;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/findUsages/DartServerFindUsagesHandler", "mayBeChangeToNameIdentifier"));
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/findUsages/DartServerFindUsagesHandler", "mayBeChangeToNameIdentifier"));
        }
        return psiElement;
    }

    public boolean processElementUsages(final @NotNull PsiElement elementToSearch, final @NotNull Processor<UsageInfo> processor, @NotNull FindUsagesOptions options) {
        if (elementToSearch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToSearch", "com/jetbrains/lang/dart/ide/findUsages/DartServerFindUsagesHandler", "processElementUsages"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/lang/dart/ide/findUsages/DartServerFindUsagesHandler", "processElementUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/jetbrains/lang/dart/ide/findUsages/DartServerFindUsagesHandler", "processElementUsages"));
        }
        final SearchScope scope = options.searchScope;
        Project project = (Project)ReadAction.compute(() -> this.getProject());
        final DartAnalysisServerService service = DartAnalysisServerService.getInstance(project);
        ReadActionConsumer<SearchResult> searchResultProcessor = new ReadActionConsumer<SearchResult>(){

            @Override
            public void consumeInReadAction(SearchResult result) {
                UsageInfo usageInfo;
                if (result.getKind().equals("DECLARATION")) {
                    return;
                }
                Location location = result.getLocation();
                VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)location.getFile()));
                if (vFile == null) {
                    return;
                }
                if (!scope.contains(vFile)) {
                    return;
                }
                PsiFile psiFile = elementToSearch.getManager().findFile(vFile);
                if (psiFile == null) {
                    return;
                }
                int offset = service.getConvertedOffset(vFile, location.getOffset());
                int length = service.getConvertedOffset(vFile, location.getOffset() + location.getLength()) - offset;
                TextRange range = TextRange.create((int)offset, (int)(offset + length));
                boolean potentialUsage = result.isPotential();
                PsiElement usageElement = DartServerFindUsagesHandler.getUsagePsiElement(psiFile, range);
                UsageInfo usageInfo2 = usageInfo = usageElement == null ? null : DartServerFindUsagesHandler.getUsageInfo(usageElement, range, potentialUsage);
                if (usageInfo != null && usageInfo.getElement() != null && (!(scope instanceof LocalSearchScope) || PsiSearchScopeUtil.isInScope((LocalSearchScope)((LocalSearchScope)scope), (PsiElement)usageInfo.getElement()))) {
                    processor.process((Object)usageInfo);
                }
            }
        };
        VirtualFile file = (VirtualFile)ReadAction.compute(() -> {
            if (elementToSearch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToSearch", "com/jetbrains/lang/dart/ide/findUsages/DartServerFindUsagesHandler", "lambda$processElementUsages$1"));
            }
            return elementToSearch.getContainingFile().getVirtualFile();
        });
        int offset = elementToSearch.getTextRange().getStartOffset();
        service.search_findElementReferences(file, offset, (Consumer<SearchResult>)searchResultProcessor);
        return true;
    }

    @Nullable
    public static UsageInfo getUsageInfo(@NotNull PsiElement usageElement, @NotNull TextRange range, boolean potentialUsage) {
        if (usageElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageElement", "com/jetbrains/lang/dart/ide/findUsages/DartServerFindUsagesHandler", "getUsageInfo"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/lang/dart/ide/findUsages/DartServerFindUsagesHandler", "getUsageInfo"));
        }
        int offset = range.getStartOffset() - usageElement.getTextRange().getStartOffset();
        boolean nonCodeUsage = usageElement instanceof PsiComment || usageElement.getParent() instanceof PsiComment;
        UsageInfo usageInfo = new UsageInfo(usageElement, offset, offset + range.getLength(), nonCodeUsage);
        usageInfo.setDynamicUsage(potentialUsage);
        return usageInfo;
    }

    @Nullable
    public static PsiElement getUsagePsiElement(@NotNull PsiFile psiFile, @NotNull TextRange textRange) {
        PsiElement parent;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/lang/dart/ide/findUsages/DartServerFindUsagesHandler", "getUsagePsiElement"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/jetbrains/lang/dart/ide/findUsages/DartServerFindUsagesHandler", "getUsagePsiElement"));
        }
        PsiElement element = psiFile.findElementAt(textRange.getStartOffset());
        if (element == null) {
            return null;
        }
        boolean rangeOk = element.getTextRange().contains(textRange);
        if (rangeOk && element instanceof DartReference) {
            return element;
        }
        TextRange previousRange = element.getTextRange();
        while ((parent = element.getParent()) != null) {
            TextRange parentRange = parent.getTextRange();
            if (rangeOk) {
                if (!parentRange.equals((Object)previousRange)) {
                    return element;
                }
                if (parent instanceof DartReference) {
                    return parent;
                }
                previousRange = parentRange;
                element = parent;
                continue;
            }
            rangeOk = parent.getTextRange().contains(textRange);
            if (rangeOk && parent instanceof DartReference) {
                return parent;
            }
            previousRange = parentRange;
            element = parent;
        }
        return null;
    }
}

