/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.DartTokenTypesSets;
import org.jetbrains.annotations.Nullable;

public class DartAlignmentProcessor {
    private final ASTNode myNode;
    private final Alignment myBaseAlignment;
    private final CommonCodeStyleSettings mySettings;

    public DartAlignmentProcessor(ASTNode node, CommonCodeStyleSettings settings) {
        this.myNode = node;
        this.mySettings = settings;
        this.myBaseAlignment = Alignment.createAlignment();
    }

    @Nullable
    public Alignment createChildAlignment() {
        IElementType elementType = this.myNode.getElementType();
        if (DartTokenTypesSets.BINARY_EXPRESSIONS.contains(elementType) && this.mySettings.ALIGN_MULTILINE_BINARY_OPERATION) {
            return this.myBaseAlignment;
        }
        if (elementType == DartTokenTypes.TERNARY_EXPRESSION && this.mySettings.ALIGN_MULTILINE_TERNARY_OPERATION) {
            return this.myBaseAlignment;
        }
        if (elementType == DartTokenTypes.FORMAL_PARAMETER_LIST && this.mySettings.ALIGN_MULTILINE_PARAMETERS) {
            return this.myBaseAlignment;
        }
        if (elementType == DartTokenTypes.ARGUMENTS && this.mySettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS) {
            return this.myBaseAlignment;
        }
        return null;
    }
}

