/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.templateLanguages.BlockWithParent;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.DartTokenTypesSets;
import com.jetbrains.lang.dart.ide.formatter.DartAlignmentProcessor;
import com.jetbrains.lang.dart.ide.formatter.DartBlockContext;
import com.jetbrains.lang.dart.ide.formatter.DartIndentProcessor;
import com.jetbrains.lang.dart.ide.formatter.DartSpacingProcessor;
import com.jetbrains.lang.dart.ide.formatter.DartWrappingProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartBlock
extends AbstractBlock
implements BlockWithParent {
    public static final List<DartBlock> DART_EMPTY = Collections.emptyList();
    private static final TokenSet STATEMENTS_WITH_OPTIONAL_BRACES = TokenSet.create((IElementType[])new IElementType[]{DartTokenTypes.IF_STATEMENT, DartTokenTypes.WHILE_STATEMENT, DartTokenTypes.FOR_STATEMENT});
    private static final TokenSet LAST_TOKENS_IN_SWITCH_CASE = TokenSet.create((IElementType[])new IElementType[]{DartTokenTypes.BREAK_STATEMENT, DartTokenTypes.CONTINUE_STATEMENT, DartTokenTypes.RETURN_STATEMENT});
    private final DartIndentProcessor myIndentProcessor;
    private final DartSpacingProcessor mySpacingProcessor;
    private final DartWrappingProcessor myWrappingProcessor;
    private final DartAlignmentProcessor myAlignmentProcessor;
    private final CodeStyleSettings mySettings;
    private final DartBlockContext myContext;
    private Wrap myChildWrap = null;
    private final Indent myIndent;
    private BlockWithParent myParent;
    private List<DartBlock> mySubDartBlocks;

    protected DartBlock(ASTNode node, Wrap wrap, Alignment alignment, CodeStyleSettings settings, DartBlockContext context) {
        super(node, wrap, alignment);
        this.mySettings = settings;
        this.myContext = context;
        this.myIndentProcessor = new DartIndentProcessor(context.getDartSettings());
        this.mySpacingProcessor = new DartSpacingProcessor(node, context.getDartSettings());
        this.myWrappingProcessor = new DartWrappingProcessor(node, context.getDartSettings());
        this.myAlignmentProcessor = new DartAlignmentProcessor(node, context.getDartSettings());
        this.myIndent = this.myIndentProcessor.getChildIndent(this.myNode, context.getMode());
    }

    public Indent getIndent() {
        return this.myIndent;
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/jetbrains/lang/dart/ide/formatter/DartBlock", "getSpacing"));
        }
        return this.mySpacingProcessor.getSpacing(child1, child2);
    }

    protected List<Block> buildChildren() {
        if (this.isLeaf()) {
            return EMPTY;
        }
        ArrayList<Block> tlChildren = new ArrayList<Block>();
        for (ASTNode childNode = this.getNode().getFirstChildNode(); childNode != null; childNode = childNode.getTreeNext()) {
            if (FormatterUtil.containsWhiteSpacesOnly((ASTNode)childNode)) continue;
            DartBlock childBlock = new DartBlock(childNode, this.createChildWrap(childNode), this.createChildAlignment(childNode), this.mySettings, this.myContext);
            childBlock.setParent(this);
            tlChildren.add((Block)childBlock);
        }
        return tlChildren;
    }

    public Wrap createChildWrap(ASTNode child) {
        IElementType childType = child.getElementType();
        Wrap wrap = this.myWrappingProcessor.createChildWrap(child, Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), this.myChildWrap);
        if (childType == DartTokenTypes.ASSIGNMENT_OPERATOR) {
            this.myChildWrap = wrap;
        }
        return wrap;
    }

    @Nullable
    protected Alignment createChildAlignment(ASTNode child) {
        IElementType type = child.getElementType();
        if (type != DartTokenTypes.LPAREN && !DartTokenTypesSets.BLOCKS.contains(type)) {
            return this.myAlignmentProcessor.createChildAlignment();
        }
        return null;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newIndex) {
        ASTNode child;
        IElementType previousType;
        IElementType elementType = this.myNode.getElementType();
        DartBlock previousBlock = newIndex == 0 ? null : this.getSubDartBlocks().get(newIndex - 1);
        IElementType iElementType = previousType = previousBlock == null ? null : previousBlock.getNode().getElementType();
        if (previousType == DartTokenTypes.LBRACE || previousType == DartTokenTypes.LBRACKET) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/formatter/DartBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (previousType == DartTokenTypes.RPAREN && STATEMENTS_WITH_OPTIONAL_BRACES.contains(elementType)) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/formatter/DartBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (previousType == DartTokenTypes.COLON && (elementType == DartTokenTypes.SWITCH_CASE || elementType == DartTokenTypes.DEFAULT_CASE)) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/formatter/DartBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (previousType == DartTokenTypes.SWITCH_CASE || previousType == DartTokenTypes.DEFAULT_CASE) {
            DartBlock lastChildInPrevBlock;
            List<DartBlock> subSubBlocks;
            List<DartBlock> subBlocks;
            if (previousBlock != null && !(subBlocks = previousBlock.getSubDartBlocks()).isEmpty() && DartBlock.isLastTokenInSwitchCase(subSubBlocks = (lastChildInPrevBlock = subBlocks.get(subBlocks.size() - 1)).getSubDartBlocks())) {
                ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
                if (childAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/formatter/DartBlock", "getChildAttributes"));
                }
                return childAttributes;
            }
            int indentSize = this.mySettings.getIndentSize((FileType)DartFileType.INSTANCE) * 2;
            ChildAttributes childAttributes = new ChildAttributes(Indent.getIndent((Indent.Type)Indent.Type.SPACES, (int)indentSize, (boolean)false, (boolean)false), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/formatter/DartBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (previousBlock == null) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/formatter/DartBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (!previousBlock.isIncomplete() && newIndex < this.getSubDartBlocks().size() && previousType != TokenType.ERROR_ELEMENT) {
            ChildAttributes childAttributes = new ChildAttributes(previousBlock.getIndent(), previousBlock.getAlignment());
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/formatter/DartBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (this.myParent instanceof DartBlock && ((DartBlock)this.myParent).isIncomplete() && ((child = this.myNode.getFirstChildNode()) == null || child.getElementType() != DartTokenTypes.OPEN_QUOTE || child.getTextLength() != 3)) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getContinuationIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/formatter/DartBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (this.myParent == null && this.isIncomplete()) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getContinuationIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/formatter/DartBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = new ChildAttributes(previousBlock.getIndent(), previousBlock.getAlignment());
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/formatter/DartBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    private static boolean isLastTokenInSwitchCase(@NotNull List<DartBlock> blocks) {
        if (blocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocks", "com/jetbrains/lang/dart/ide/formatter/DartBlock", "isLastTokenInSwitchCase"));
        }
        int size = blocks.size();
        if (size == 0) {
            return false;
        }
        DartBlock lastBlock = blocks.get(size - 1);
        IElementType type = lastBlock.getNode().getElementType();
        if (LAST_TOKENS_IN_SWITCH_CASE.contains(type)) {
            return true;
        }
        if (type == DartTokenTypes.SEMICOLON && size > 1) {
            DartBlock lastBlock2 = blocks.get(size - 2);
            return lastBlock2.getNode().getElementType() == DartTokenTypes.THROW_EXPRESSION;
        }
        return false;
    }

    public List<DartBlock> getSubDartBlocks() {
        if (this.mySubDartBlocks == null) {
            this.mySubDartBlocks = new ArrayList<DartBlock>();
            for (Block block : this.getSubBlocks()) {
                this.mySubDartBlocks.add((DartBlock)block);
            }
            this.mySubDartBlocks = !this.mySubDartBlocks.isEmpty() ? this.mySubDartBlocks : DART_EMPTY;
        }
        return this.mySubDartBlocks;
    }

    public boolean isLeaf() {
        return false;
    }

    public BlockWithParent getParent() {
        return this.myParent;
    }

    public void setParent(BlockWithParent newParent) {
        this.myParent = newParent;
    }
}

