/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilderEx;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.jetbrains.lang.dart.ide.formatter.DartBlock;
import com.jetbrains.lang.dart.ide.formatter.DartBlockContext;
import com.jetbrains.lang.dart.psi.DartFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartFormattingModelBuilder
implements FormattingModelBuilderEx {
    @NotNull
    public FormattingModel createModel(@NotNull PsiElement element, @NotNull CodeStyleSettings settings) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/formatter/DartFormattingModelBuilder", "createModel"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/lang/dart/ide/formatter/DartFormattingModelBuilder", "createModel"));
        }
        FormattingModel formattingModel = this.createModel(element, settings, FormattingMode.REFORMAT);
        if (formattingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/formatter/DartFormattingModelBuilder", "createModel"));
        }
        return formattingModel;
    }

    @Nullable
    public TextRange getRangeAffectingIndent(PsiFile file, int offset, ASTNode elementAtOffset) {
        return null;
    }

    @NotNull
    public FormattingModel createModel(@NotNull PsiElement element, @NotNull CodeStyleSettings settings, @NotNull FormattingMode mode) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/formatter/DartFormattingModelBuilder", "createModel"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/lang/dart/ide/formatter/DartFormattingModelBuilder", "createModel"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/jetbrains/lang/dart/ide/formatter/DartFormattingModelBuilder", "createModel"));
        }
        PsiFile psiFile = element.getContainingFile();
        FileASTNode rootNode = psiFile instanceof DartFile ? psiFile.getNode() : element.getNode();
        DartBlockContext context = new DartBlockContext(settings, mode);
        DartBlock rootBlock = new DartBlock((ASTNode)rootNode, null, null, settings, context);
        DocumentBasedFormattingModel documentBasedFormattingModel = new DocumentBasedFormattingModel((Block)rootBlock, element.getProject(), settings, psiFile.getFileType(), psiFile);
        if (documentBasedFormattingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/formatter/DartFormattingModelBuilder", "createModel"));
        }
        return documentBasedFormattingModel;
    }

    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsToUse(@NotNull PsiFile file, @NotNull FormatTextRanges ranges, @NotNull CodeStyleSettings settings) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/formatter/DartFormattingModelBuilder", "getIndentOptionsToUse"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/jetbrains/lang/dart/ide/formatter/DartFormattingModelBuilder", "getIndentOptionsToUse"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/lang/dart/ide/formatter/DartFormattingModelBuilder", "getIndentOptionsToUse"));
        }
        return null;
    }
}

