/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.formatter;

import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Key;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.WrappingUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.DartTokenTypesSets;
import com.jetbrains.lang.dart.ide.formatter.DartIndentProcessor;
import com.jetbrains.lang.dart.ide.formatter.DartSpacingProcessor;

public class DartWrappingProcessor {
    private static final Key<Wrap> DART_TERNARY_EXPRESSION_WRAP_KEY = Key.create((String)"TERNARY_EXPRESSION_WRAP_KEY");
    private static final Key<Wrap> DART_EXPRESSION_LIST_WRAP_KEY = Key.create((String)"EXPRESSION_LIST_WRAP_KEY");
    private static final Key<Wrap> DART_ARGUMENT_LIST_WRAP_KEY = Key.create((String)"ARGUMENT_LIST_WRAP_KEY");
    private static final Key<Wrap> DART_TYPE_LIST_WRAP_KEY = Key.create((String)"TYPE_LIST_WRAP_KEY");
    private static final TokenSet NAMED_ARGUMENTS = TokenSet.create((IElementType[])new IElementType[]{DartTokenTypes.NAMED_ARGUMENT});
    private final ASTNode myNode;
    private final CommonCodeStyleSettings mySettings;

    public DartWrappingProcessor(ASTNode node, CommonCodeStyleSettings settings) {
        this.myNode = node;
        this.mySettings = settings;
    }

    Wrap createChildWrap(ASTNode child, Wrap defaultWrap, Wrap childWrap) {
        IElementType childType = child.getElementType();
        IElementType elementType = this.myNode.getElementType();
        if (childType == DartTokenTypes.COMMA || childType == DartTokenTypes.SEMICOLON) {
            return defaultWrap;
        }
        if (elementType == DartTokenTypes.ARGUMENT_LIST && this.mySettings.CALL_PARAMETERS_WRAP != 0) {
            if (!this.mySettings.PREFER_PARAMETERS_WRAP && childWrap != null) {
                return Wrap.createChildWrap((Wrap)childWrap, (WrapType)WrappingUtil.getWrapType((int)this.mySettings.CALL_PARAMETERS_WRAP), (boolean)true);
            }
            Wrap wrap = null;
            if (this.myNode.getFirstChildNode() == child && childType != DartTokenTypes.NAMED_ARGUMENT) {
                ASTNode[] childs = this.myNode.getChildren(DartIndentProcessor.EXPRESSIONS);
                wrap = childs.length >= 7 ? Wrap.createWrap((WrapType)WrapType.ALWAYS, (boolean)true) : Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
                if (this.myNode.getLastChildNode() != child) {
                    this.myNode.putUserData(DART_ARGUMENT_LIST_WRAP_KEY, (Object)wrap);
                }
            } else {
                if (childType == DartTokenTypes.NAMED_ARGUMENT) {
                    ASTNode[] named = this.myNode.getChildren(NAMED_ARGUMENTS);
                    wrap = (Wrap)this.myNode.getUserData(DART_ARGUMENT_LIST_WRAP_KEY);
                    if (child == named[0] && named.length > 1) {
                        ASTNode[] childs = this.myNode.getChildren(DartIndentProcessor.EXPRESSIONS);
                        Wrap namedWrap = childs.length >= 7 || named.length > 4 ? Wrap.createWrap((WrapType)WrapType.ALWAYS, (boolean)true) : Wrap.createWrap((WrapType)WrapType.CHOP_DOWN_IF_LONG, (boolean)true);
                        this.myNode.putUserData(DART_ARGUMENT_LIST_WRAP_KEY, (Object)namedWrap);
                    }
                } else {
                    wrap = (Wrap)this.myNode.getUserData(DART_ARGUMENT_LIST_WRAP_KEY);
                }
                if (this.myNode.getLastChildNode() == child) {
                    this.myNode.putUserData(DART_ARGUMENT_LIST_WRAP_KEY, null);
                }
            }
            if (childType == DartTokenTypesSets.MULTI_LINE_COMMENT || childType == DartTokenTypes.FUNCTION_EXPRESSION) {
                return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
            }
            return wrap != null ? wrap : Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.mySettings.CALL_PARAMETERS_WRAP), (boolean)false);
        }
        if (elementType == DartTokenTypes.FORMAL_PARAMETER_LIST && this.mySettings.METHOD_PARAMETERS_WRAP != 0) {
            if (this.myNode.getFirstChildNode() == child) {
                return DartWrappingProcessor.createWrap(this.mySettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE);
            }
            if (childType == DartTokenTypes.RPAREN) {
                return DartWrappingProcessor.createWrap(this.mySettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE);
            }
            return Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.mySettings.METHOD_PARAMETERS_WRAP), (boolean)true);
        }
        if (elementType == DartTokenTypes.INITIALIZERS) {
            if (childType != DartTokenTypes.COLON && DartWrappingProcessor.isNotFirstInitializer(child)) {
                return Wrap.createWrap((WrapType)WrapType.ALWAYS, (boolean)true);
            }
            if (childType == DartTokenTypes.COLON && !DartSpacingProcessor.hasMultipleInitializers(child)) {
                return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
            }
        }
        if (elementType == DartTokenTypes.EXPRESSION_LIST) {
            Wrap wrap = null;
            if (this.myNode.getFirstChildNode() == child) {
                wrap = Wrap.createWrap((WrapType)WrapType.CHOP_DOWN_IF_LONG, (boolean)true);
                if (this.myNode.getLastChildNode() != child) {
                    this.myNode.putUserData(DART_EXPRESSION_LIST_WRAP_KEY, (Object)wrap);
                }
            } else {
                wrap = (Wrap)this.myNode.getUserData(DART_EXPRESSION_LIST_WRAP_KEY);
            }
            if (childType == DartTokenTypesSets.MULTI_LINE_COMMENT || childType == DartTokenTypes.CONST) {
                return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
            }
            return wrap != null ? wrap : Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
        }
        if (elementType == DartTokenTypes.LIST_LITERAL_EXPRESSION && childType == DartTokenTypes.RBRACKET) {
            ASTNode exprList = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)child);
            Wrap wrap = null;
            if (exprList != null && exprList.getElementType() == DartTokenTypes.EXPRESSION_LIST) {
                wrap = (Wrap)exprList.getUserData(DART_EXPRESSION_LIST_WRAP_KEY);
                exprList.putUserData(DART_EXPRESSION_LIST_WRAP_KEY, null);
            }
            return wrap != null ? wrap : Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
        }
        if (elementType == DartTokenTypes.MAP_LITERAL_EXPRESSION) {
            Wrap wrap = this.sharedWrap(child, DART_EXPRESSION_LIST_WRAP_KEY);
            if (childType == DartTokenTypes.LBRACE || childType == DartTokenTypes.LBRACKET) {
                return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
            }
            if (childType == DartTokenTypesSets.MULTI_LINE_COMMENT || childType == DartTokenTypes.CONST) {
                return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
            }
            return wrap != null ? wrap : Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
        }
        if (elementType == DartTokenTypes.FUNCTION_BODY && FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)DartTokenTypes.EXPRESSION_BODY_DEF)) {
            return DartWrappingProcessor.createWrap(true);
        }
        if (childType == DartTokenTypes.CALL_EXPRESSION) {
            if (FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)DartTokenTypes.EXPRESSION_BODY_DEF)) {
                return DartWrappingProcessor.createWrap(true);
            }
            if (this.mySettings.CALL_PARAMETERS_WRAP != 0 && childType == DartTokenTypes.RPAREN) {
                return DartWrappingProcessor.createWrap(this.mySettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE);
            }
        }
        if (elementType == DartTokenTypes.IF_STATEMENT) {
            if (childType == DartTokenTypes.ELSE) {
                return DartWrappingProcessor.createWrap(this.mySettings.ELSE_ON_NEW_LINE);
            }
            if (!DartTokenTypesSets.BLOCKS.contains(childType) && child == child.getTreeParent().getLastChildNode()) {
                return DartWrappingProcessor.createWrap(true);
            }
        }
        if (DartTokenTypesSets.BINARY_EXPRESSIONS.contains(elementType) && this.mySettings.BINARY_OPERATION_WRAP != 0 && (this.mySettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE && DartTokenTypesSets.BINARY_OPERATORS.contains(childType) || !this.mySettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE && this.isRightOperand(child))) {
            return Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.mySettings.BINARY_OPERATION_WRAP), (boolean)true);
        }
        if (elementType == DartTokenTypes.ASSIGN_EXPRESSION && this.mySettings.ASSIGNMENT_WRAP != 0) {
            if (childType != DartTokenTypes.ASSIGNMENT_OPERATOR) {
                if (FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)DartTokenTypes.ASSIGNMENT_OPERATOR) && this.mySettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE) {
                    return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
                }
                return Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.mySettings.ASSIGNMENT_WRAP), (boolean)true);
            }
            if (this.mySettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE) {
                return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
            }
        }
        if (elementType == DartTokenTypes.TERNARY_EXPRESSION) {
            if (this.myNode.getFirstChildNode() != child) {
                if (this.mySettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE) {
                    if (childType == DartTokenTypes.QUEST) {
                        Wrap wrap = Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.mySettings.TERNARY_OPERATION_WRAP), (boolean)true);
                        this.myNode.putUserData(DART_TERNARY_EXPRESSION_WRAP_KEY, (Object)wrap);
                        return wrap;
                    }
                    if (childType == DartTokenTypes.COLON) {
                        Wrap wrap = (Wrap)this.myNode.getUserData(DART_TERNARY_EXPRESSION_WRAP_KEY);
                        this.myNode.putUserData(DART_TERNARY_EXPRESSION_WRAP_KEY, null);
                        return wrap != null ? wrap : Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.mySettings.TERNARY_OPERATION_WRAP), (boolean)true);
                    }
                } else if (childType != DartTokenTypes.QUEST && childType != DartTokenTypes.COLON) {
                    return Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.mySettings.TERNARY_OPERATION_WRAP), (boolean)true);
                }
            }
            return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
        }
        if (childType == DartTokenTypes.HIDE_COMBINATOR || childType == DartTokenTypes.SHOW_COMBINATOR) {
            return DartWrappingProcessor.createWrap(true);
        }
        if (childType == DartTokenTypes.VAR_DECLARATION_LIST && elementType != DartTokenTypes.FOR_LOOP_PARTS) {
            if (DartWrappingProcessor.varDeclListContainsVarInit(child)) {
                return Wrap.createWrap((WrapType)WrapType.ALWAYS, (boolean)true);
            }
            return Wrap.createWrap((WrapType)WrapType.CHOP_DOWN_IF_LONG, (boolean)true);
        }
        if (childType == DartTokenTypes.VAR_DECLARATION_LIST_PART) {
            ASTNode parent = this.getParent();
            if (parent != null && parent.getElementType() == DartTokenTypes.FOR_LOOP_PARTS) {
                return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
            }
            if (DartWrappingProcessor.varDeclListContainsVarInit(this.myNode)) {
                return Wrap.createWrap((WrapType)WrapType.ALWAYS, (boolean)true);
            }
            return Wrap.createWrap((WrapType)WrapType.CHOP_DOWN_IF_LONG, (boolean)true);
        }
        if (elementType == DartTokenTypes.CLASS_DEFINITION && (childType == DartTokenTypes.SUPERCLASS || childType == DartTokenTypes.INTERFACES || childType == DartTokenTypes.MIXINS)) {
            return Wrap.createWrap((WrapType)WrapType.CHOP_DOWN_IF_LONG, (boolean)true);
        }
        if (elementType == DartTokenTypes.MIXIN_APPLICATION && childType == DartTokenTypes.MIXINS) {
            return Wrap.createWrap((WrapType)WrapType.CHOP_DOWN_IF_LONG, (boolean)true);
        }
        if (elementType == DartTokenTypes.ENUM_DEFINITION && childType == DartTokenTypes.ENUM_CONSTANT_DECLARATION) {
            return Wrap.createWrap((WrapType)WrapType.CHOP_DOWN_IF_LONG, (boolean)true);
        }
        if (elementType == DartTokenTypes.TYPE_LIST && childType == DartTokenTypes.TYPE) {
            Wrap wrap = this.sharedWrap(child, DART_TYPE_LIST_WRAP_KEY);
            if (childType == DartTokenTypesSets.MULTI_LINE_COMMENT) {
                return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
            }
            return wrap == null ? Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true) : wrap;
        }
        if (elementType == DartTokenTypes.REFERENCE_EXPRESSION && (childType == DartTokenTypes.DOT || childType == DartTokenTypes.QUEST_DOT)) {
            return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
        }
        return defaultWrap;
    }

    private boolean isRightOperand(ASTNode child) {
        return this.myNode.getLastChildNode() == child;
    }

    private ASTNode getParent() {
        return this.myNode.getTreeParent();
    }

    private static Wrap createWrap(boolean isNormal) {
        return Wrap.createWrap((WrapType)(isNormal ? WrapType.NORMAL : WrapType.NONE), (boolean)true);
    }

    private static boolean varDeclListContainsVarInit(ASTNode decl) {
        if (decl.findChildByType(DartTokenTypes.VAR_INIT) != null) {
            return true;
        }
        for (ASTNode child = decl.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.findChildByType(DartTokenTypes.VAR_INIT) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean isNotFirstInitializer(ASTNode child) {
        ASTNode prev = child;
        boolean isFirst = false;
        while ((prev = prev.getTreePrev()) != null) {
            if (prev.getElementType() == DartTokenTypes.COLON) {
                return isFirst;
            }
            if (prev.getElementType() == DartTokenTypesSets.WHITE_SPACE || DartTokenTypesSets.COMMENTS.contains(prev.getElementType())) continue;
            isFirst = true;
        }
        return isFirst;
    }

    private Wrap sharedWrap(ASTNode child, Key<Wrap> key) {
        Wrap wrap = null;
        if (this.myNode.getFirstChildNode() == child) {
            wrap = Wrap.createWrap((WrapType)WrapType.CHOP_DOWN_IF_LONG, (boolean)true);
            if (this.myNode.getLastChildNode() != child) {
                this.myNode.putUserData(key, (Object)wrap);
            }
        } else {
            wrap = (Wrap)this.myNode.getUserData(key);
            if (this.myNode.getLastChildNode() == child) {
                this.myNode.putUserData(key, null);
            }
        }
        return wrap;
    }
}

