/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.generation;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.lang.dart.ide.DartNamedElementNode;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartClassMembers;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.util.DartClassResolveResult;
import com.jetbrains.lang.dart.util.DartGenericSpecialization;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCreateMethodsFix<T extends DartComponent> {
    protected static final String DART_TEMPLATE_GROUP = "Dart";
    private final Set<T> elementsToProcess;
    @NotNull
    protected final DartClass myDartClass;
    protected final DartGenericSpecialization specializations;
    protected PsiElement anchor;

    public BaseCreateMethodsFix(@NotNull DartClass dartClass) {
        if (dartClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/ide/generation/BaseCreateMethodsFix", "<init>"));
        }
        this.elementsToProcess = new LinkedHashSet<T>();
        this.anchor = null;
        this.myDartClass = dartClass;
        this.specializations = DartClassResolveResult.create(dartClass).getSpecialization();
    }

    protected void evalAnchor(@Nullable Editor editor, PsiElement context) {
        PsiElement next;
        if (editor == null) {
            return;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        DartClassMembers body = DartResolveUtil.getBody(this.myDartClass);
        assert (body != null);
        for (PsiElement child : body.getChildren()) {
            if (child.getTextRange().getStartOffset() > caretOffset) break;
            this.anchor = child;
        }
        PsiElement psiElement = next = this.anchor == null ? null : this.anchor.getNextSibling();
        while (next != null && (next instanceof PsiWhiteSpace || ";".equals(next.getText()))) {
            this.anchor = next;
            next = this.anchor.getNextSibling();
        }
        if (this.anchor == null) {
            this.anchor = body;
        }
    }

    public void setCaretSafe(Editor editor, int offset) {
        DartClassMembers body = DartResolveUtil.getBody(this.myDartClass);
        if (body == null) {
            editor.getCaretModel().moveToOffset(offset);
        } else {
            TextRange bodyRange = body.getTextRange();
            editor.getCaretModel().moveToOffset(bodyRange.containsOffset(offset) ? offset : bodyRange.getEndOffset());
        }
    }

    public void beforeInvoke(@NotNull Project project, Editor editor, PsiElement file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/generation/BaseCreateMethodsFix", "beforeInvoke"));
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiElement context) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/generation/BaseCreateMethodsFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(context.getContainingFile())) {
            return;
        }
        this.evalAnchor(editor, context);
        this.processElements(project, editor, this.getElementsToProcess());
    }

    protected void processElements(@NotNull Project project, @NotNull Editor editor, @NotNull Set<T> elementsToProcess) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/generation/BaseCreateMethodsFix", "processElements"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/generation/BaseCreateMethodsFix", "processElements"));
        }
        if (elementsToProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsToProcess", "com/jetbrains/lang/dart/ide/generation/BaseCreateMethodsFix", "processElements"));
        }
        if (elementsToProcess.isEmpty()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                HintManager.getInstance().showErrorHint(editor, this.getNothingFoundMessage());
            }
            return;
        }
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        for (DartComponent e : elementsToProcess) {
            this.anchor = this.doAddMethodsForOne(editor, templateManager, this.buildFunctionsText(templateManager, e), this.anchor);
        }
    }

    @NotNull
    protected abstract String getNothingFoundMessage();

    @Nullable
    protected abstract Template buildFunctionsText(TemplateManager var1, T var2);

    public PsiElement doAddMethodsForOne(@NotNull Editor editor, @NotNull TemplateManager templateManager, @Nullable Template functionTemplate, @NotNull PsiElement anchor) throws IncorrectOperationException {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/generation/BaseCreateMethodsFix", "doAddMethodsForOne"));
        }
        if (templateManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateManager", "com/jetbrains/lang/dart/ide/generation/BaseCreateMethodsFix", "doAddMethodsForOne"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/lang/dart/ide/generation/BaseCreateMethodsFix", "doAddMethodsForOne"));
        }
        if (functionTemplate != null) {
            this.setCaretSafe(editor, anchor.getTextRange().getEndOffset());
            templateManager.startTemplate(editor, functionTemplate);
            PsiElement dartComponent = PsiTreeUtil.getParentOfType((PsiElement)anchor.findElementAt(editor.getCaretModel().getOffset()), DartComponent.class);
            return dartComponent != null ? dartComponent : anchor;
        }
        return anchor;
    }

    public void addElementToProcess(T function) {
        this.elementsToProcess.add(function);
    }

    public void addElementsToProcessFrom(@Nullable Collection<DartNamedElementNode> selectedElements) {
        if (selectedElements == null) {
            return;
        }
        for (DartNamedElementNode el : selectedElements) {
            this.addElementToProcess((DartComponent)el.getPsiElement());
        }
    }

    @NotNull
    public Set<T> getElementsToProcess() {
        DartComponent[] objects = this.elementsToProcess.toArray(new DartComponent[this.elementsToProcess.size()]);
        Comparator<DartComponent> tComparator = Comparator.comparingInt(o -> o.getTextRange().getStartOffset());
        int size = this.elementsToProcess.size();
        LinkedHashSet result = new LinkedHashSet(size);
        ArrayList<DartComponent> objectsFromSameFile = new ArrayList<DartComponent>();
        PsiFile containingFile = null;
        for (int i = 0; i < size; ++i) {
            DartComponent object = objects[i];
            PsiFile currentContainingFile = object.getContainingFile();
            if (currentContainingFile != containingFile) {
                if (containingFile != null) {
                    Collections.sort(objectsFromSameFile, tComparator);
                    result.addAll(objectsFromSameFile);
                    objectsFromSameFile.clear();
                }
                containingFile = currentContainingFile;
            }
            objectsFromSameFile.add(object);
        }
        Collections.sort(objectsFromSameFile, tComparator);
        result.addAll(objectsFromSameFile);
        this.elementsToProcess.clear();
        this.elementsToProcess.addAll(result);
        Set<T> set = this.elementsToProcess;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/generation/BaseCreateMethodsFix", "getElementsToProcess"));
        }
        return set;
    }
}

