/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.generation;

import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.ide.DartNamedElementNode;
import com.jetbrains.lang.dart.ide.generation.BaseCreateMethodsFix;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartClassDefinition;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDartGenerateHandler
implements LanguageCodeInsightActionHandler {
    private static final Condition<DartComponent> NOT_CONSTRUCTOR_CONDITION = component -> DartComponentType.typeOf((PsiElement)component) != DartComponentType.CONSTRUCTOR;
    private static final Condition<DartComponent> NOT_STATIC_CONDITION = component -> !component.isStatic();

    public boolean isValidFor(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler", "isValidFor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler", "isValidFor"));
        }
        return file instanceof DartFile && PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), DartClass.class) != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler", "invoke"));
        }
        this.invoke(project, editor, file, editor.getCaretModel().getOffset());
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, int offset) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler", "invoke"));
        }
        DartClass dartClass = (DartClass)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), DartClassDefinition.class);
        if (dartClass == null) {
            return;
        }
        ArrayList<DartComponent> candidates = new ArrayList<DartComponent>();
        this.collectCandidates(dartClass, candidates);
        List selectedElements = Collections.emptyList();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            selectedElements = ContainerUtil.map(candidates, namedComponent -> new DartNamedElementNode((DartComponent)namedComponent));
        } else if (!candidates.isEmpty()) {
            MemberChooser<DartNamedElementNode> chooser = this.createMemberChooserDialog(project, dartClass, candidates, this.getTitle());
            chooser.show();
            if (chooser.getExitCode() != 0) {
                return;
            }
            selectedElements = chooser.getSelectedElements();
        }
        this.doInvoke(project, editor, file, selectedElements, this.createFix(dartClass));
    }

    protected void doInvoke(final @NotNull Project project, final @NotNull Editor editor, final @NotNull PsiFile file, final @NotNull Collection<DartNamedElementNode> selectedElements, final @NotNull BaseCreateMethodsFix createMethodsFix) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler", "doInvoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler", "doInvoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler", "doInvoke"));
        }
        if (selectedElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedElements", "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler", "doInvoke"));
        }
        if (createMethodsFix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createMethodsFix", "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler", "doInvoke"));
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                createMethodsFix.addElementsToProcessFrom(selectedElements);
                createMethodsFix.beforeInvoke(project, editor, (PsiElement)file);
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            createMethodsFix.invoke(project, editor, (PsiElement)file);
                        }
                        catch (IncorrectOperationException ex) {
                            Logger.getInstance((String)this.getClass().getName()).error((Throwable)ex);
                        }
                    }
                });
            }
        };
        if (CommandProcessor.getInstance().getCurrentCommand() == null) {
            CommandProcessor.getInstance().executeCommand(project, runnable, this.getClass().getName(), null);
        } else {
            runnable.run();
        }
    }

    @NotNull
    protected abstract BaseCreateMethodsFix createFix(@NotNull DartClass var1);

    @NotNull
    protected abstract String getTitle();

    protected abstract void collectCandidates(@NotNull DartClass var1, @NotNull List<DartComponent> var2);

    @NotNull
    protected final Map<Pair<String, Boolean>, DartComponent> computeClassMembersMap(@NotNull DartClass dartClass, boolean doIncludeStatics) {
        if (dartClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler", "computeClassMembersMap"));
        }
        List classMembers = DartResolveUtil.getNamedSubComponents(dartClass);
        classMembers = ContainerUtil.filter(classMembers, NOT_CONSTRUCTOR_CONDITION);
        if (!doIncludeStatics) {
            classMembers = ContainerUtil.filter((Collection)classMembers, NOT_STATIC_CONDITION);
        }
        Map<Pair<String, Boolean>, DartComponent> map = DartResolveUtil.namedComponentToMap(classMembers);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler", "computeClassMembersMap"));
        }
        return map;
    }

    @NotNull
    protected final Map<Pair<String, Boolean>, DartComponent> computeSuperClassesMemberMap(@NotNull DartClass dartClass) {
        if (dartClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler", "computeSuperClassesMemberMap"));
        }
        ArrayList<DartClass> superClasses = new ArrayList<DartClass>();
        ArrayList<DartClass> superInterfaces = new ArrayList<DartClass>();
        DartResolveUtil.collectSupers(superClasses, superInterfaces, dartClass);
        List<DartComponent> superClassesMembers = new ArrayList();
        for (DartClass superClass : superClasses) {
            superClassesMembers.addAll(DartResolveUtil.getNamedSubComponents(superClass));
        }
        superClassesMembers = ContainerUtil.filter(superClassesMembers, NOT_CONSTRUCTOR_CONDITION);
        superClassesMembers = ContainerUtil.filter(superClassesMembers, NOT_STATIC_CONDITION);
        Map<Pair<String, Boolean>, DartComponent> map = DartResolveUtil.namedComponentToMap(superClassesMembers);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler", "computeSuperClassesMemberMap"));
        }
        return map;
    }

    @NotNull
    protected final Map<Pair<String, Boolean>, DartComponent> computeSuperInterfacesMembersMap(@NotNull DartClass dartClass) {
        if (dartClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler", "computeSuperInterfacesMembersMap"));
        }
        ArrayList<DartClass> superClasses = new ArrayList<DartClass>();
        ArrayList<DartClass> superInterfaces = new ArrayList<DartClass>();
        DartResolveUtil.collectSupers(superClasses, superInterfaces, dartClass);
        List<DartComponent> superInterfacesMembers = new ArrayList();
        for (DartClass superInterface : superInterfaces) {
            superInterfacesMembers.addAll(DartResolveUtil.getNamedSubComponents(superInterface));
        }
        superInterfacesMembers = ContainerUtil.filter(superInterfacesMembers, NOT_CONSTRUCTOR_CONDITION);
        superInterfacesMembers = ContainerUtil.filter(superInterfacesMembers, NOT_STATIC_CONDITION);
        Map<Pair<String, Boolean>, DartComponent> map = DartResolveUtil.namedComponentToMap(superInterfacesMembers);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler", "computeSuperInterfacesMembersMap"));
        }
        return map;
    }

    @Nullable
    protected JComponent getOptionsComponent(DartClass jsClass, Collection<DartComponent> candidates) {
        return null;
    }

    protected MemberChooser<DartNamedElementNode> createMemberChooserDialog(@NotNull Project project, final @NotNull DartClass dartClass, final @NotNull Collection<DartComponent> candidates, @NotNull String title) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler", "createMemberChooserDialog"));
        }
        if (dartClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler", "createMemberChooserDialog"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler", "createMemberChooserDialog"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler", "createMemberChooserDialog"));
        }
        List nodes = ContainerUtil.map(candidates, namedComponent -> new DartNamedElementNode((DartComponent)namedComponent));
        MemberChooser<DartNamedElementNode> chooser = new MemberChooser<DartNamedElementNode>(nodes.toArray(new DartNamedElementNode[0]), this.doAllowEmptySelection(), true, project, false){

            protected JComponent createCenterPanel() {
                JComponent superComponent = super.createCenterPanel();
                JComponent optionsComponent = BaseDartGenerateHandler.this.getOptionsComponent(dartClass, candidates);
                if (optionsComponent == null) {
                    return superComponent;
                }
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)superComponent, "Center");
                panel.add((Component)optionsComponent, "South");
                return panel;
            }
        };
        chooser.setTitle(title);
        chooser.setCopyJavadocVisible(false);
        return chooser;
    }

    protected boolean doAllowEmptySelection() {
        return false;
    }
}

