/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.generation;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.generation.BaseCreateMethodsFix;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartReturnType;
import com.jetbrains.lang.dart.psi.DartType;
import com.jetbrains.lang.dart.util.DartPresentableUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateGetterSetterFix
extends BaseCreateMethodsFix<DartComponent> {
    @NotNull
    private final Strategy myStrategy;

    public CreateGetterSetterFix(@NotNull DartClass dartClass, @NotNull Strategy strategy) {
        if (dartClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/ide/generation/CreateGetterSetterFix", "<init>"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/jetbrains/lang/dart/ide/generation/CreateGetterSetterFix", "<init>"));
        }
        super(dartClass);
        this.myStrategy = strategy;
    }

    @Override
    @NotNull
    protected String getNothingFoundMessage() {
        String string = this.myStrategy.myNothingFoundMessage;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/generation/CreateGetterSetterFix", "getNothingFoundMessage"));
        }
        return string;
    }

    @Override
    protected Template buildFunctionsText(TemplateManager templateManager, DartComponent namedComponent) {
        DartReturnType returnType = (DartReturnType)PsiTreeUtil.getChildOfType((PsiElement)namedComponent, DartReturnType.class);
        DartType dartType = (DartType)PsiTreeUtil.getChildOfType((PsiElement)namedComponent, DartType.class);
        String typeText = returnType == null ? DartPresentableUtil.buildTypeText(namedComponent, dartType, null) : DartPresentableUtil.buildTypeText(namedComponent, returnType, null);
        Template template = templateManager.createTemplate(this.getClass().getName(), "Dart");
        template.setToReformat(true);
        if (this.myStrategy == Strategy.GETTER || this.myStrategy == Strategy.GETTERSETTER) {
            CreateGetterSetterFix.buildGetter(template, namedComponent.getName(), typeText, namedComponent.isStatic());
        }
        if (this.myStrategy == Strategy.SETTER || this.myStrategy == Strategy.GETTERSETTER) {
            CreateGetterSetterFix.buildSetter(template, namedComponent.getName(), typeText, namedComponent.isStatic());
        }
        return template;
    }

    private static void buildGetter(Template template, String name, String typeText, boolean isStatic) {
        CreateGetterSetterFix.build(template, name, typeText, isStatic, true);
    }

    private static void buildSetter(Template template, String name, String typeText, boolean isStatic) {
        CreateGetterSetterFix.build(template, name, typeText, isStatic, false);
    }

    private static void build(Template template, String name, String typeText, boolean isStatic, boolean isGetter) {
        if (isStatic) {
            template.addTextSegment("static");
            template.addTextSegment(" ");
        }
        if (isGetter) {
            template.addTextSegment(typeText);
            template.addTextSegment(" ");
        }
        template.addTextSegment(isGetter ? "get" : "set");
        template.addTextSegment(" ");
        template.addEndVariable();
        template.addTextSegment(DartPresentableUtil.setterGetterName(name));
        if (!isGetter) {
            template.addTextSegment("(");
            template.addTextSegment(typeText);
            template.addTextSegment(" value");
            template.addTextSegment(")");
        }
        if (isGetter) {
            template.addTextSegment(" => ");
            template.addTextSegment(name);
            template.addTextSegment("; ");
        } else {
            template.addTextSegment("{ ");
            template.addTextSegment(name);
            template.addTextSegment(" = value; ");
            template.addTextSegment(" } ");
        }
    }

    public static enum Strategy {
        GETTER(DartBundle.message("dart.fix.getter.none.found", new Object[0])){

            @Override
            boolean accept(String name, List<DartComponent> componentList) {
                return name.startsWith("_") && ContainerUtil.find(componentList, component -> component.isGetter() && DartPresentableUtil.setterGetterName(name).equals(component.getName())) == null;
            }
        }
        ,
        SETTER(DartBundle.message("dart.fix.setter.none.found", new Object[0])){

            @Override
            boolean accept(String name, List<DartComponent> componentList) {
                return name.startsWith("_") && ContainerUtil.find(componentList, component -> component.isSetter() && DartPresentableUtil.setterGetterName(name).equals(component.getName())) == null;
            }
        }
        ,
        GETTERSETTER(DartBundle.message("dart.fix.gettersetter.none.found", new Object[0])){

            @Override
            boolean accept(String name, List<DartComponent> componentList) {
                return name.startsWith("_") && ContainerUtil.find(componentList, component -> (component.isGetter() || component.isSetter()) && DartPresentableUtil.setterGetterName(name).equals(component.getName())) == null;
            }
        };

        private final String myNothingFoundMessage;

        private Strategy(String nothingFoundMessage) {
            this.myNothingFoundMessage = nothingFoundMessage;
        }

        abstract boolean accept(String var1, List<DartComponent> var2);
    }
}

