/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.generation;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.ide.generation.BaseCreateMethodsFix;
import com.jetbrains.lang.dart.ide.generation.BaseDartGenerateHandler;
import com.jetbrains.lang.dart.ide.generation.CreateGetterSetterFix;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class DartGenerateAccessorHandler
extends BaseDartGenerateHandler {
    private final CreateGetterSetterFix.Strategy myStrategy;

    protected DartGenerateAccessorHandler(CreateGetterSetterFix.Strategy strategy) {
        this.myStrategy = strategy;
    }

    @Override
    @NotNull
    protected BaseCreateMethodsFix createFix(@NotNull DartClass dartClass) {
        if (dartClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/ide/generation/DartGenerateAccessorHandler", "createFix"));
        }
        CreateGetterSetterFix createGetterSetterFix = new CreateGetterSetterFix(dartClass, this.myStrategy);
        if (createGetterSetterFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/generation/DartGenerateAccessorHandler", "createFix"));
        }
        return createGetterSetterFix;
    }

    @Override
    protected void collectCandidates(@NotNull DartClass dartClass, @NotNull List<DartComponent> candidates) {
        if (dartClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/ide/generation/DartGenerateAccessorHandler", "collectCandidates"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/jetbrains/lang/dart/ide/generation/DartGenerateAccessorHandler", "collectCandidates"));
        }
        List<DartComponent> subComponents = DartResolveUtil.getNamedSubComponents(dartClass);
        candidates.addAll(ContainerUtil.findAll(this.computeClassMembersMap(dartClass, true).values(), component -> DartComponentType.typeOf((PsiElement)component) == DartComponentType.FIELD && this.myStrategy.accept(component.getName(), subComponents)));
    }
}

