/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.generation;

import com.jetbrains.lang.dart.ide.generation.BaseDartGenerateAction;
import com.jetbrains.lang.dart.ide.generation.BaseDartGenerateHandler;
import com.jetbrains.lang.dart.ide.generation.DartGenerateEqualsAndHashcodeHandler;
import com.jetbrains.lang.dart.psi.DartClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartGenerateEqualsAndHashcodeAction
extends BaseDartGenerateAction {
    private static final String EQUALS_OP = "==";
    private static final String HASHCODE = "hashCode";

    @Override
    @NotNull
    protected BaseDartGenerateHandler getGenerateHandler() {
        DartGenerateEqualsAndHashcodeHandler dartGenerateEqualsAndHashcodeHandler = new DartGenerateEqualsAndHashcodeHandler();
        if (dartGenerateEqualsAndHashcodeHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/generation/DartGenerateEqualsAndHashcodeAction", "getGenerateHandler"));
        }
        return dartGenerateEqualsAndHashcodeHandler;
    }

    @Override
    protected boolean doEnable(@Nullable DartClass dartClass) {
        if (dartClass == null) {
            return false;
        }
        return !DartGenerateEqualsAndHashcodeAction.doesClassContainEqualsAndHashCode(dartClass);
    }

    public static boolean doesClassContainEqualsAndHashCode(@NotNull DartClass dartClass) {
        if (dartClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/ide/generation/DartGenerateEqualsAndHashcodeAction", "doesClassContainEqualsAndHashCode"));
        }
        return DartGenerateEqualsAndHashcodeAction.doesClassContainMethod(dartClass, EQUALS_OP) && DartGenerateEqualsAndHashcodeAction.doesClassContainGetter(dartClass, HASHCODE);
    }
}

