/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.generation;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.ide.generation.BaseCreateMethodsFix;
import com.jetbrains.lang.dart.ide.generation.BaseDartGenerateHandler;
import com.jetbrains.lang.dart.ide.generation.CreateEqualsAndHashcodeFix;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DartGenerateEqualsAndHashcodeHandler
extends BaseDartGenerateHandler {
    @Override
    @NotNull
    protected String getTitle() {
        String string = DartBundle.message("dart.generate.equalsAndHashcode", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/generation/DartGenerateEqualsAndHashcodeHandler", "getTitle"));
        }
        return string;
    }

    @Override
    @NotNull
    protected BaseCreateMethodsFix createFix(@NotNull DartClass dartClass) {
        if (dartClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/ide/generation/DartGenerateEqualsAndHashcodeHandler", "createFix"));
        }
        CreateEqualsAndHashcodeFix createEqualsAndHashcodeFix = new CreateEqualsAndHashcodeFix(dartClass);
        if (createEqualsAndHashcodeFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/generation/DartGenerateEqualsAndHashcodeHandler", "createFix"));
        }
        return createEqualsAndHashcodeFix;
    }

    @Override
    protected void collectCandidates(@NotNull DartClass dartClass, @NotNull List<DartComponent> candidates) {
        if (dartClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/ide/generation/DartGenerateEqualsAndHashcodeHandler", "collectCandidates"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/jetbrains/lang/dart/ide/generation/DartGenerateEqualsAndHashcodeHandler", "collectCandidates"));
        }
        candidates.addAll(ContainerUtil.findAll(this.computeClassMembersMap(dartClass, false).values(), component -> DartComponentType.typeOf((PsiElement)component) == DartComponentType.FIELD));
    }

    @Override
    protected boolean doAllowEmptySelection() {
        return true;
    }
}

