/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.generation;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.generation.BaseCreateMethodsFix;
import com.jetbrains.lang.dart.ide.generation.BaseDartGenerateHandler;
import com.jetbrains.lang.dart.ide.generation.OverrideImplementMethodFix;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DartImplementMethodHandler
extends BaseDartGenerateHandler {
    @Override
    @NotNull
    protected String getTitle() {
        String string = DartBundle.message("dart.implement.method", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/generation/DartImplementMethodHandler", "getTitle"));
        }
        return string;
    }

    @Override
    @NotNull
    protected BaseCreateMethodsFix createFix(@NotNull DartClass dartClass) {
        if (dartClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/ide/generation/DartImplementMethodHandler", "createFix"));
        }
        OverrideImplementMethodFix overrideImplementMethodFix = new OverrideImplementMethodFix(dartClass, true);
        if (overrideImplementMethodFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/generation/DartImplementMethodHandler", "createFix"));
        }
        return overrideImplementMethodFix;
    }

    @Override
    protected void collectCandidates(@NotNull DartClass dartClass, @NotNull List<DartComponent> candidates) {
        if (dartClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/ide/generation/DartImplementMethodHandler", "collectCandidates"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/jetbrains/lang/dart/ide/generation/DartImplementMethodHandler", "collectCandidates"));
        }
        THashMap result = new THashMap(this.computeSuperInterfacesMembersMap(dartClass));
        THashMap superClassesMemberMap = new THashMap(this.computeSuperClassesMemberMap(dartClass));
        result.keySet().removeAll(superClassesMemberMap.keySet());
        for (Map.Entry entry : superClassesMemberMap.entrySet()) {
            DartComponent component2 = (DartComponent)entry.getValue();
            if (!component2.isAbstract() || result.containsKey(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        result.keySet().removeAll(this.computeClassMembersMap(dartClass, false).keySet());
        candidates.addAll(ContainerUtil.findAll(result.values(), component -> {
            if (dartClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/ide/generation/DartImplementMethodHandler", "lambda$collectCandidates$0"));
            }
            return component.isPublic() || DartResolveUtil.sameLibrary((PsiElement)dartClass, (PsiElement)component);
        }));
    }
}

