/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.generation;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.ide.generation.BaseCreateMethodsFix;
import com.jetbrains.lang.dart.ide.generation.BaseDartGenerateHandler;
import com.jetbrains.lang.dart.ide.generation.OverrideImplementMethodFix;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import gnu.trove.THashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DartOverrideMethodHandler
extends BaseDartGenerateHandler {
    @Override
    @NotNull
    protected String getTitle() {
        String string = DartBundle.message("dart.override.method", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/generation/DartOverrideMethodHandler", "getTitle"));
        }
        return string;
    }

    @Override
    @NotNull
    protected BaseCreateMethodsFix createFix(@NotNull DartClass dartClass) {
        if (dartClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/ide/generation/DartOverrideMethodHandler", "createFix"));
        }
        OverrideImplementMethodFix overrideImplementMethodFix = new OverrideImplementMethodFix(dartClass, false);
        if (overrideImplementMethodFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/generation/DartOverrideMethodHandler", "createFix"));
        }
        return overrideImplementMethodFix;
    }

    @Override
    protected void collectCandidates(@NotNull DartClass dartClass, @NotNull List<DartComponent> candidates) {
        if (dartClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/ide/generation/DartOverrideMethodHandler", "collectCandidates"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/jetbrains/lang/dart/ide/generation/DartOverrideMethodHandler", "collectCandidates"));
        }
        THashMap result = new THashMap(this.computeSuperClassesMemberMap(dartClass));
        result.keySet().removeAll(this.computeClassMembersMap(dartClass, false).keySet());
        candidates.addAll(ContainerUtil.findAll(result.values(), component -> {
            if (dartClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/ide/generation/DartOverrideMethodHandler", "lambda$collectCandidates$0"));
            }
            return DartComponentType.typeOf((PsiElement)component) != DartComponentType.FIELD && (component.isPublic() || DartResolveUtil.sameLibrary((PsiElement)dartClass, (PsiElement)component));
        }));
    }
}

