/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.generation;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.generation.BaseCreateMethodsFix;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartReturnType;
import com.jetbrains.lang.dart.psi.DartType;
import com.jetbrains.lang.dart.psi.DartVarAccessDeclaration;
import com.jetbrains.lang.dart.psi.DartVarDeclarationListPart;
import com.jetbrains.lang.dart.util.DartPresentableUtil;
import org.jetbrains.annotations.NotNull;

public class OverrideImplementMethodFix
extends BaseCreateMethodsFix<DartComponent> {
    final boolean myImplementNotOverride;

    public OverrideImplementMethodFix(@NotNull DartClass dartClass, boolean implementNotOverride) {
        if (dartClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/ide/generation/OverrideImplementMethodFix", "<init>"));
        }
        super(dartClass);
        this.myImplementNotOverride = implementNotOverride;
    }

    @Override
    @NotNull
    protected String getNothingFoundMessage() {
        String string = DartBundle.message(this.myImplementNotOverride ? "dart.fix.implement.none.found" : "dart.fix.override.none.found", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/generation/OverrideImplementMethodFix", "getNothingFoundMessage"));
        }
        return string;
    }

    @Override
    protected Template buildFunctionsText(TemplateManager templateManager, DartComponent element) {
        boolean isField;
        Template template = templateManager.createTemplate(this.getClass().getName(), "Dart");
        template.setToReformat(true);
        if (CodeStyleSettingsManager.getSettings((Project)element.getProject()).INSERT_OVERRIDE_ANNOTATION) {
            template.addTextSegment("@override\n");
        }
        boolean bl = isField = element instanceof DartVarAccessDeclaration || element instanceof DartVarDeclarationListPart;
        if (isField && element.isFinal()) {
            template.addTextSegment("final");
            template.addTextSegment(" ");
        }
        DartReturnType returnType = (DartReturnType)PsiTreeUtil.getChildOfType((PsiElement)element, DartReturnType.class);
        DartType dartType = (DartType)PsiTreeUtil.getChildOfType((PsiElement)element, DartType.class);
        if (returnType != null) {
            template.addTextSegment(DartPresentableUtil.buildTypeText(element, returnType, this.specializations));
            template.addTextSegment(" ");
        } else if (dartType != null) {
            template.addTextSegment(DartPresentableUtil.buildTypeText(element, dartType, this.specializations));
            template.addTextSegment(" ");
        }
        if (isField) {
            if (returnType == null && dartType == null) {
                template.addTextSegment("var");
                template.addTextSegment(" ");
            }
            template.addTextSegment(element.getName());
            if (element.isFinal()) {
                template.addTextSegment(" ");
                template.addTextSegment("=");
                template.addTextSegment(" ");
                template.addTextSegment("null");
            }
            template.addTextSegment("; ");
            return template;
        }
        if (element.isOperator()) {
            template.addTextSegment("operator ");
        }
        if (element.isGetter() || element.isSetter()) {
            template.addTextSegment(element.isGetter() ? "get " : "set ");
        }
        template.addTextSegment(element.getName());
        if (!element.isGetter()) {
            template.addTextSegment("(");
            template.addTextSegment(DartPresentableUtil.getPresentableParameterList(element, this.specializations, false, true, true));
            template.addTextSegment(")");
        }
        template.addTextSegment("{\n");
        template.addEndVariable();
        template.addTextSegment("\n} ");
        return template;
    }
}

