/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.hierarchy;

import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartNewExpression;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.dartlang.analysis.server.protocol.Element;
import org.dartlang.analysis.server.protocol.Location;
import org.dartlang.analysis.server.protocol.TypeHierarchyItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartHierarchyUtil {
    private static final Comparator<NodeDescriptor> NODE_DESCRIPTOR_COMPARATOR = (first, second) -> first.getIndex() - second.getIndex();

    private DartHierarchyUtil() {
    }

    @Nullable
    public static DartClass findDartClass(@NotNull Project project, @NotNull TypeHierarchyItem item) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/hierarchy/DartHierarchyUtil", "findDartClass"));
        }
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/lang/dart/ide/hierarchy/DartHierarchyUtil", "findDartClass"));
        }
        Element classElement = item.getClassElement();
        Location location = classElement.getLocation();
        DartComponent component = DartHierarchyUtil.findDartComponent(project, location);
        return component instanceof DartClass ? (DartClass)component : null;
    }

    public static Comparator<NodeDescriptor> getComparator(Project project) {
        HierarchyBrowserManager.State state = HierarchyBrowserManager.getInstance((Project)project).getState();
        if (state != null && state.SORT_ALPHABETICALLY) {
            return AlphaComparator.INSTANCE;
        }
        return NODE_DESCRIPTOR_COMPARATOR;
    }

    @NotNull
    public static List<TypeHierarchyItem> getTypeHierarchyItems(@NotNull DartClass dartClass) {
        if (dartClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/ide/hierarchy/DartHierarchyUtil", "getTypeHierarchyItems"));
        }
        VirtualFile file = dartClass.getContainingFile().getVirtualFile();
        DartComponentName name = dartClass.getComponentName();
        if (name == null) {
            List<TypeHierarchyItem> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/DartHierarchyUtil", "getTypeHierarchyItems"));
            }
            return list;
        }
        List<TypeHierarchyItem> list = DartAnalysisServerService.getInstance(dartClass.getProject()).search_getTypeHierarchy(file, name.getTextRange().getStartOffset(), false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/DartHierarchyUtil", "getTypeHierarchyItems"));
        }
        return list;
    }

    public static boolean isExecutable(@NotNull PsiElement component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/lang/dart/ide/hierarchy/DartHierarchyUtil", "isExecutable"));
        }
        if (component instanceof DartComponentName) {
            return false;
        }
        DartComponentType componentType = DartComponentType.typeOf(component);
        if (componentType == null) {
            return false;
        }
        switch (componentType) {
            case CONSTRUCTOR: 
            case FUNCTION: 
            case METHOD: 
            case OPERATOR: {
                return true;
            }
        }
        return false;
    }

    public static PsiElement getResolvedElementAtCursor(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (project == null || editor == null) {
            return null;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        PsiElement psiElement = file == null ? null : file.findElementAt(editor.getCaretModel().getOffset());
        DartReference dartReference = (DartReference)PsiTreeUtil.getParentOfType((PsiElement)psiElement, DartReference.class);
        if (dartReference != null) {
            DartComponent comp;
            if (dartReference.getTokenType() == DartTokenTypes.NEW_EXPRESSION) {
                DartComponent cons = DartResolveUtil.findConstructorDeclaration((DartNewExpression)dartReference);
                if (cons != null && cons.getTokenType() == DartTokenTypes.METHOD_DECLARATION) {
                    return cons;
                }
                return null;
            }
            if (dartReference.getTokenType() == DartTokenTypes.CALL_EXPRESSION) {
                dartReference = DartHierarchyUtil.getRightmostReference(dartReference.getFirstChild());
            }
            return (comp = DartResolveUtil.findReferenceAndComponentTarget((PsiElement)dartReference)) != null && DartHierarchyUtil.isExecutable((PsiElement)comp) ? comp : null;
        }
        if (psiElement == null) {
            return null;
        }
        if (DartHierarchyUtil.isExecutable(psiElement)) {
            return psiElement;
        }
        DartComponentName name = (DartComponentName)PsiTreeUtil.getParentOfType((PsiElement)psiElement, DartComponentName.class);
        if (name == null) {
            if (psiElement instanceof PsiWhiteSpace) {
                name = (DartComponentName)PsiTreeUtil.getPrevSiblingOfType((PsiElement)psiElement, DartComponentName.class);
            } else if ("(".equals(psiElement.getText())) {
                name = (DartComponentName)PsiTreeUtil.getPrevSiblingOfType((PsiElement)psiElement.getParent(), DartComponentName.class);
            }
        }
        if (name != null) {
            PsiElement def = name.getParent();
            return def != null && DartHierarchyUtil.isExecutable(def) ? def : null;
        }
        return null;
    }

    private static DartReference getRightmostReference(PsiElement element) {
        PsiElement last = PsiTreeUtil.getDeepestLast((PsiElement)element);
        return (DartReference)PsiTreeUtil.getParentOfType((PsiElement)last, DartReference.class);
    }

    @Nullable
    public static DartComponent findDartComponent(@NotNull Project project, @NotNull Location location) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/hierarchy/DartHierarchyUtil", "findDartComponent"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/jetbrains/lang/dart/ide/hierarchy/DartHierarchyUtil", "findDartComponent"));
        }
        String filePath = location.getFile();
        if (filePath == null) {
            return null;
        }
        filePath = FileUtil.toSystemIndependentName((String)filePath);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (virtualFile == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        int offset = DartAnalysisServerService.getInstance(project).getConvertedOffset(virtualFile, location.getOffset());
        PsiElement elementAtOffset = psiFile.findElementAt(offset);
        return (DartComponent)PsiTreeUtil.getParentOfType((PsiElement)elementAtOffset, DartComponent.class);
    }
}

