/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.hierarchy.call;

import com.intellij.ide.hierarchy.CallHierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.PopupHandler;
import com.jetbrains.lang.dart.ide.hierarchy.DartHierarchyUtil;
import com.jetbrains.lang.dart.ide.hierarchy.call.DartCalleeTreeStructure;
import com.jetbrains.lang.dart.ide.hierarchy.call.DartCallerTreeStructure;
import com.jetbrains.lang.dart.ide.hierarchy.call.DartHierarchyNodeDescriptor;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartCallHierarchyBrowser
extends CallHierarchyBrowserBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.lang.dart.ide.hierarchy.call.DartCallHierarchyBrowser");
    private static final String GROUP_DART_CALL_HIERARCHY_POPUP = "DartCallHierarchyPopupMenu";

    public DartCallHierarchyBrowser(Project project, PsiElement method) {
        super(project, method);
    }

    @Nullable
    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCallHierarchyBrowser", "getElementFromDescriptor"));
        }
        if (descriptor instanceof DartHierarchyNodeDescriptor) {
            DartHierarchyNodeDescriptor pyDescriptor = (DartHierarchyNodeDescriptor)descriptor;
            return pyDescriptor.getPsiElement();
        }
        return null;
    }

    protected void createTrees(@NotNull Map<String, JTree> type2TreeMap) {
        if (type2TreeMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2TreeMap", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCallHierarchyBrowser", "createTrees"));
        }
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction(GROUP_DART_CALL_HIERARCHY_POPUP);
        type2TreeMap.put(CALLER_TYPE, this.createHierarchyTree(group));
        type2TreeMap.put(CALLEE_TYPE, this.createHierarchyTree(group));
    }

    private JTree createHierarchyTree(ActionGroup group) {
        JTree tree = this.createTree(false);
        PopupHandler.installPopupHandler((JComponent)tree, (ActionGroup)group, (String)"CallHierarchyViewPopup", (ActionManager)ActionManager.getInstance());
        return tree;
    }

    protected boolean isApplicableElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCallHierarchyBrowser", "isApplicableElement"));
        }
        return DartHierarchyUtil.isExecutable(element);
    }

    @Nullable
    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String typeName, @NotNull PsiElement psiElement) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCallHierarchyBrowser", "createHierarchyTreeStructure"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCallHierarchyBrowser", "createHierarchyTreeStructure"));
        }
        if (CALLER_TYPE.equals(typeName)) {
            return new DartCallerTreeStructure(this.myProject, psiElement, this.getCurrentScopeType());
        }
        if (CALLEE_TYPE.equals(typeName)) {
            return new DartCalleeTreeStructure(this.myProject, psiElement, this.getCurrentScopeType());
        }
        LOG.error("unexpected type: " + typeName);
        return null;
    }

    @Nullable
    protected Comparator<NodeDescriptor> getComparator() {
        return DartHierarchyUtil.getComparator(this.myProject);
    }
}

