/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.hierarchy.call;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.jetbrains.lang.dart.ide.findUsages.DartServerFindUsagesHandler;
import com.jetbrains.lang.dart.ide.hierarchy.DartHierarchyUtil;
import com.jetbrains.lang.dart.ide.hierarchy.call.DartHierarchyNodeDescriptor;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.psi.DartMethodDeclaration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DartCallHierarchyTreeStructure
extends HierarchyTreeStructure {
    private final String myScopeType;

    public DartCallHierarchyTreeStructure(Project project, PsiElement element, String currentScopeType) {
        super(project, (HierarchyNodeDescriptor)new DartHierarchyNodeDescriptor(null, element, true));
        this.myScopeType = currentScopeType;
    }

    @Nullable
    protected static FindUsagesHandler createFindUsageHandler(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCallHierarchyTreeStructure", "createFindUsageHandler"));
        }
        return new DartServerFindUsagesHandler(element);
    }

    public static void collectDeclarations(@Nullable PsiElement element, @NotNull List<PsiElement> results) {
        Condition isExecutable;
        PsiElement ref;
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCallHierarchyTreeStructure", "collectDeclarations"));
        }
        if (element != null && (ref = PsiTreeUtil.findFirstParent((PsiElement)element, (Condition)(isExecutable = object -> {
            if (object == null) {
                return false;
            }
            return DartHierarchyUtil.isExecutable(object);
        }))) != null) {
            results.add(ref);
        }
    }

    @NotNull
    protected abstract List<PsiElement> getChildren(@NotNull PsiElement var1);

    @NotNull
    protected Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCallHierarchyTreeStructure", "buildChildren"));
        }
        ArrayList<DartHierarchyNodeDescriptor> descriptors = new ArrayList<DartHierarchyNodeDescriptor>();
        if (descriptor instanceof DartHierarchyNodeDescriptor) {
            DartHierarchyNodeDescriptor dartDescriptor = (DartHierarchyNodeDescriptor)descriptor;
            PsiElement element = dartDescriptor.getPsiElement();
            if (element == null) {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCallHierarchyTreeStructure", "buildChildren"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            boolean isCallable = DartHierarchyUtil.isExecutable(element);
            HierarchyNodeDescriptor nodeDescriptor = this.getBaseDescriptor();
            if (!(element instanceof DartComponent) || !isCallable || nodeDescriptor == null) {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCallHierarchyTreeStructure", "buildChildren"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            DartComponentName name = ((DartComponent)element).getComponentName();
            if (name == null) {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCallHierarchyTreeStructure", "buildChildren"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            List<PsiElement> children = this.getChildren((PsiElement)name);
            HashMap<PsiElement, DartHierarchyNodeDescriptor> callerToDescriptorMap = new HashMap<PsiElement, DartHierarchyNodeDescriptor>();
            PsiElement baseClass = element instanceof DartMethodDeclaration ? PsiTreeUtil.getParentOfType((PsiElement)name, DartClass.class) : null;
            for (PsiElement caller : children) {
                DartHierarchyNodeDescriptor callerDescriptor;
                if (!this.isInScope(baseClass, caller, this.myScopeType) || (callerDescriptor = (DartHierarchyNodeDescriptor)((Object)callerToDescriptorMap.get(caller))) != null) continue;
                callerDescriptor = new DartHierarchyNodeDescriptor((NodeDescriptor)descriptor, caller, false);
                callerToDescriptorMap.put(caller, callerDescriptor);
                descriptors.add(callerDescriptor);
            }
        }
        Object[] objectArray = ArrayUtil.toObjectArray(descriptors);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCallHierarchyTreeStructure", "buildChildren"));
        }
        return objectArray;
    }

    @NotNull
    protected GlobalSearchScope getScope() {
        if (HierarchyBrowserBaseEx.SCOPE_CLASS.equals(this.myScopeType)) {
            DartHierarchyNodeDescriptor rootElement;
            PsiElement element;
            PsiElement file;
            Object root = this.getRootElement();
            if (root instanceof DartHierarchyNodeDescriptor && (file = PsiTreeUtil.getParentOfType((PsiElement)(element = (rootElement = (DartHierarchyNodeDescriptor)((Object)root)).getPsiElement()), DartFile.class)) != null) {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)((DartFile)file));
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCallHierarchyTreeStructure", "getScope"));
                }
                return globalSearchScope;
            }
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.myProject);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCallHierarchyTreeStructure", "getScope"));
            }
            return globalSearchScope;
        }
        if (HierarchyBrowserBaseEx.SCOPE_PROJECT.equals(this.myScopeType)) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.myProject);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCallHierarchyTreeStructure", "getScope"));
            }
            return globalSearchScope;
        }
        if (HierarchyBrowserBaseEx.SCOPE_TEST.equals(this.myScopeType)) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.myProject);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCallHierarchyTreeStructure", "getScope"));
            }
            return globalSearchScope;
        }
        if (HierarchyBrowserBaseEx.SCOPE_ALL.equals(this.myScopeType)) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myProject);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCallHierarchyTreeStructure", "getScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.myProject);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCallHierarchyTreeStructure", "getScope"));
        }
        return globalSearchScope;
    }
}

