/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.hierarchy.call;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.analyzer.DartServerData;
import com.jetbrains.lang.dart.ide.hierarchy.call.DartCallHierarchyTreeStructure;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartRecursiveVisitor;
import com.jetbrains.lang.dart.psi.DartReferenceExpression;
import com.jetbrains.lang.dart.resolve.DartResolver;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DartCalleeTreeStructure
extends DartCallHierarchyTreeStructure {
    public DartCalleeTreeStructure(Project project, PsiElement element, String currentScopeType) {
        super(project, element, currentScopeType);
    }

    private static void getCallees(@NotNull PsiElement element, @NotNull List<PsiElement> results) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCalleeTreeStructure", "getCallees"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCalleeTreeStructure", "getCallees"));
        }
        DartComponentName name = (DartComponentName)element;
        DartComponent decl = (DartComponent)name.getParent();
        PsiFile file = decl.getContainingFile();
        if (file == null) {
            return;
        }
        VirtualFile vFile = file.getVirtualFile();
        List<DartServerData.DartNavigationRegion> navRegions = DartAnalysisServerService.getInstance(element.getProject()).analysis_getNavigation(vFile, decl.getTextOffset(), decl.getTextLength());
        if (navRegions == null) {
            return;
        }
        DartCalleeTreeStructure.resolveReferences(decl, navRegions, results);
    }

    private static void resolveReferences(@NotNull DartComponent component, final @NotNull List<DartServerData.DartNavigationRegion> regions, final @NotNull List<PsiElement> results) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCalleeTreeStructure", "resolveReferences"));
        }
        if (regions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regions", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCalleeTreeStructure", "resolveReferences"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCalleeTreeStructure", "resolveReferences"));
        }
        component.acceptChildren(new DartRecursiveVisitor(){

            @Override
            public void visitReferenceExpression(@NotNull DartReferenceExpression reference) {
                if (reference == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCalleeTreeStructure$1", "visitReferenceExpression"));
                }
                int offset = reference.getTextOffset();
                List targets = DartCalleeTreeStructure.getRegionAt(offset, regions);
                for (DartServerData.DartNavigationTarget target : targets) {
                    PsiElement element;
                    if (!DartCalleeTreeStructure.isExecutable(target) || (element = DartCalleeTreeStructure.getDeclaration(target, (PsiElement)reference)) == null) continue;
                    results.add(element);
                }
                super.visitReferenceExpression(reference);
            }
        });
    }

    private static boolean isExecutable(DartServerData.DartNavigationTarget target) {
        String kind = target.getKind();
        return "METHOD".equals(kind) || "FUNCTION".equals(kind) || "GETTER".equals(kind) || "SETTER".equals(kind) || "CONSTRUCTOR".equals(kind);
    }

    private static PsiElement getDeclaration(DartServerData.DartNavigationTarget target, PsiElement reference) {
        PsiElement found = DartResolver.getElementForNavigationTarget(reference.getProject(), target);
        return found == null ? null : found.getParent();
    }

    @NotNull
    private static List<DartServerData.DartNavigationTarget> getRegionAt(int offset, @NotNull List<DartServerData.DartNavigationRegion> regions) {
        if (regions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regions", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCalleeTreeStructure", "getRegionAt"));
        }
        for (DartServerData.DartNavigationRegion region : regions) {
            int targetStart = region.getOffset();
            int targetEnd = targetStart + region.getLength();
            if (offset < targetStart || offset > targetEnd) continue;
            List<DartServerData.DartNavigationTarget> list = region.getTargets();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCalleeTreeStructure", "getRegionAt"));
            }
            return list;
        }
        ArrayList<DartServerData.DartNavigationTarget> arrayList = new ArrayList<DartServerData.DartNavigationTarget>(0);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCalleeTreeStructure", "getRegionAt"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<PsiElement> getChildren(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCalleeTreeStructure", "getChildren"));
        }
        ArrayList<PsiElement> list = new ArrayList<PsiElement>();
        DartCalleeTreeStructure.getCallees(element, list);
        ArrayList<PsiElement> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCalleeTreeStructure", "getChildren"));
        }
        return arrayList;
    }
}

