/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.hierarchy.method;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.MethodHierarchyBrowserBase;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.PopupHandler;
import com.jetbrains.lang.dart.ide.hierarchy.method.DartMethodHierarchyNodeDescriptor;
import com.jetbrains.lang.dart.ide.hierarchy.method.DartMethodHierarchyTreeStructure;
import com.jetbrains.lang.dart.psi.DartMethodDeclaration;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartMethodHierarchyBrowser
extends MethodHierarchyBrowserBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.lang.dart.ide.hierarchy.method.DartMethodHierarchyBrowser");
    private static final String GROUP_DART_METHOD_HIERARCHY_POPUP = "DartMethodHierarchyPopupMenu";

    public DartMethodHierarchyBrowser(Project project, PsiElement target) {
        super(project, target);
    }

    @Nullable
    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/lang/dart/ide/hierarchy/method/DartMethodHierarchyBrowser", "getElementFromDescriptor"));
        }
        if (descriptor instanceof DartMethodHierarchyNodeDescriptor) {
            return descriptor.getPsiElement();
        }
        return null;
    }

    protected void createTrees(@NotNull Map<String, JTree> trees) {
        if (trees == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trees", "com/jetbrains/lang/dart/ide/hierarchy/method/DartMethodHierarchyBrowser", "createTrees"));
        }
        JTree tree = this.createTree(false);
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction(GROUP_DART_METHOD_HIERARCHY_POPUP);
        PopupHandler.installPopupHandler((JComponent)tree, (ActionGroup)group, (String)"MethodHierarchyViewPopup", (ActionManager)ActionManager.getInstance());
        trees.put(METHOD_TYPE, tree);
    }

    @Nullable
    protected JPanel createLegendPanel() {
        return DartMethodHierarchyBrowser.createStandardLegendPanel((String)IdeBundle.message((String)"hierarchy.legend.method.is.defined.in.class", (Object[])new Object[0]), (String)IdeBundle.message((String)"hierarchy.legend.method.defined.in.superclass", (Object[])new Object[0]), (String)IdeBundle.message((String)"hierarchy.legend.method.should.be.defined", (Object[])new Object[0]));
    }

    protected boolean isApplicableElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/hierarchy/method/DartMethodHierarchyBrowser", "isApplicableElement"));
        }
        return element instanceof DartMethodDeclaration;
    }

    @Nullable
    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String type, @NotNull PsiElement psiElement) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/lang/dart/ide/hierarchy/method/DartMethodHierarchyBrowser", "createHierarchyTreeStructure"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/lang/dart/ide/hierarchy/method/DartMethodHierarchyBrowser", "createHierarchyTreeStructure"));
        }
        if (!METHOD_TYPE.equals(type)) {
            LOG.error("unexpected type: " + type);
            return null;
        }
        return new DartMethodHierarchyTreeStructure(this.myProject, (DartMethodDeclaration)psiElement);
    }

    @Nullable
    protected Comparator<NodeDescriptor> getComparator() {
        return null;
    }
}

