/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.hierarchy.method;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.jetbrains.lang.dart.ide.hierarchy.method.DartMethodHierarchyTreeStructure;
import com.jetbrains.lang.dart.psi.DartClass;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DartMethodHierarchyNodeDescriptor
extends HierarchyNodeDescriptor {
    private static final String INVALID_PREFIX = IdeBundle.message((String)"node.hierarchy.invalid", (Object[])new Object[0]);
    private DartMethodHierarchyTreeStructure myTreeStructure;
    private Icon myRawIcon;
    private Icon myStateIcon;
    protected boolean myIsImplementor;
    protected boolean myShouldImplement;
    protected boolean myIsSuperclassOfImplementor;

    protected DartMethodHierarchyNodeDescriptor(@NotNull Project project, NodeDescriptor parentDescriptor, PsiElement type, boolean isBase, @NotNull DartMethodHierarchyTreeStructure treeStructure) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/hierarchy/method/DartMethodHierarchyNodeDescriptor", "<init>"));
        }
        if (treeStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeStructure", "com/jetbrains/lang/dart/ide/hierarchy/method/DartMethodHierarchyNodeDescriptor", "<init>"));
        }
        super(project, parentDescriptor, type, isBase);
        this.myIsImplementor = false;
        this.myShouldImplement = false;
        this.myIsSuperclassOfImplementor = false;
        assert (type instanceof DartClass);
        this.myTreeStructure = treeStructure;
    }

    public final void setTreeStructure(DartMethodHierarchyTreeStructure treeStructure) {
        this.myTreeStructure = treeStructure;
    }

    public final DartClass getType() {
        return (DartClass)this.getPsiElement();
    }

    public final boolean update() {
        boolean changes = super.update();
        CompositeAppearance oldText = this.myHighlightedText;
        this.myHighlightedText = new CompositeAppearance();
        DartClass dartClass = this.getType();
        if (dartClass == null) {
            if (!this.myHighlightedText.getText().startsWith(INVALID_PREFIX)) {
                this.myHighlightedText.getBeginning().addText(INVALID_PREFIX, HierarchyNodeDescriptor.getInvalidPrefixAttributes());
            }
            return true;
        }
        ItemPresentation presentation = dartClass.getPresentation();
        Icon baseIcon = null;
        Icon stateIcon = null;
        if (presentation != null) {
            this.myHighlightedText.getEnding().addText(presentation.getPresentableText());
            PsiFile file = dartClass.getContainingFile();
            if (file != null) {
                this.myHighlightedText.getEnding().addText(" (" + file.getName() + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
            }
            baseIcon = presentation.getIcon(false);
            stateIcon = this.calculateStateIcon(dartClass);
        }
        if (changes || baseIcon != this.myRawIcon || stateIcon != this.myStateIcon) {
            changes = true;
            Icon newIcon = this.myRawIcon = baseIcon;
            this.myStateIcon = stateIcon;
            if (this.myIsBase) {
                LayeredIcon icon = new LayeredIcon(2);
                icon.setIcon(newIcon, 0);
                newIcon = icon;
                icon.setIcon(AllIcons.Hierarchy.Base, 1, -AllIcons.Hierarchy.Base.getIconWidth() / 2, 0);
            }
            if (this.myStateIcon != null) {
                newIcon = new RowIcon(new Icon[]{this.myStateIcon, newIcon});
            }
            this.setIcon(newIcon);
        }
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes = true;
        }
        return changes;
    }

    private Icon calculateStateIcon(DartClass dartClass) {
        if (this.myIsImplementor) {
            return AllIcons.Hierarchy.MethodDefined;
        }
        if (this.myShouldImplement) {
            return AllIcons.Hierarchy.ShouldDefineMethod;
        }
        if (!this.myIsBase) {
            return AllIcons.Hierarchy.MethodNotDefined;
        }
        return null;
    }
}

