/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.hierarchy.type;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.hierarchy.DartHierarchyUtil;
import com.jetbrains.lang.dart.ide.hierarchy.type.DartTypeHierarchyNodeDescriptor;
import com.jetbrains.lang.dart.psi.DartClass;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.dartlang.analysis.server.protocol.TypeHierarchyItem;
import org.jetbrains.annotations.NotNull;

public class DartServerSubtypesHierarchyTreeStructure
extends HierarchyTreeStructure {
    private final String myCurrentScopeType;

    public DartServerSubtypesHierarchyTreeStructure(Project project, DartClass dartClass, String currentScopeType) {
        super(project, (HierarchyNodeDescriptor)new DartTypeHierarchyNodeDescriptor(project, null, dartClass, true));
        this.myCurrentScopeType = currentScopeType;
    }

    @NotNull
    protected final Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSubtypesHierarchyTreeStructure", "buildChildren"));
        }
        DartClass dartClass = ((DartTypeHierarchyNodeDescriptor)descriptor).getDartClass();
        if (dartClass == null) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSubtypesHierarchyTreeStructure", "buildChildren"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        if ("Object".equals(dartClass.getName())) {
            Object[] objectArray = new Object[]{DartBundle.message("dart.hierarchy.object", new Object[0])};
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSubtypesHierarchyTreeStructure", "buildChildren"));
            }
            return objectArray;
        }
        List<TypeHierarchyItem> items = DartHierarchyUtil.getTypeHierarchyItems(dartClass);
        if (items.isEmpty()) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSubtypesHierarchyTreeStructure", "buildChildren"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        DartServerSubtypesHierarchyTreeStructure.addSubClassHierarchy(Sets.newHashSet(), this.myProject, items, items.get(0), descriptor);
        Object[] objectArray = descriptor.getCachedChildren();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSubtypesHierarchyTreeStructure", "buildChildren"));
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSubClassHierarchy(@NotNull Set<TypeHierarchyItem> stackItems, @NotNull Project project, @NotNull List<TypeHierarchyItem> items, @NotNull TypeHierarchyItem item, @NotNull HierarchyNodeDescriptor descriptor) {
        if (stackItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackItems", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSubtypesHierarchyTreeStructure", "addSubClassHierarchy"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSubtypesHierarchyTreeStructure", "addSubClassHierarchy"));
        }
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSubtypesHierarchyTreeStructure", "addSubClassHierarchy"));
        }
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSubtypesHierarchyTreeStructure", "addSubClassHierarchy"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSubtypesHierarchyTreeStructure", "addSubClassHierarchy"));
        }
        if (!stackItems.add(item)) {
            descriptor.setCachedChildren(ArrayUtil.EMPTY_OBJECT_ARRAY);
            return;
        }
        ArrayList subDescriptors = Lists.newArrayList();
        try {
            for (int index : item.getSubclasses()) {
                TypeHierarchyItem subItem = items.get(index);
                DartClass subClass = DartHierarchyUtil.findDartClass(project, subItem);
                if (subClass == null) continue;
                DartTypeHierarchyNodeDescriptor subDescriptor = new DartTypeHierarchyNodeDescriptor(project, descriptor, subClass, false);
                subDescriptors.add(subDescriptor);
                DartServerSubtypesHierarchyTreeStructure.addSubClassHierarchy(stackItems, project, items, subItem, subDescriptor);
            }
        }
        finally {
            stackItems.remove(item);
        }
        descriptor.setCachedChildren((Object[])subDescriptors.toArray(new HierarchyNodeDescriptor[subDescriptors.size()]));
    }
}

