/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.hierarchy.type;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.jetbrains.lang.dart.ide.hierarchy.DartHierarchyUtil;
import com.jetbrains.lang.dart.ide.hierarchy.type.DartTypeHierarchyNodeDescriptor;
import com.jetbrains.lang.dart.psi.DartClass;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.dartlang.analysis.server.protocol.TypeHierarchyItem;
import org.jetbrains.annotations.NotNull;

public final class DartServerSupertypesHierarchyTreeStructure
extends HierarchyTreeStructure {
    public DartServerSupertypesHierarchyTreeStructure(Project project, DartClass dartClass) {
        super(project, (HierarchyNodeDescriptor)new DartTypeHierarchyNodeDescriptor(project, null, dartClass, true));
    }

    @NotNull
    protected final Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSupertypesHierarchyTreeStructure", "buildChildren"));
        }
        DartClass dartClass = ((DartTypeHierarchyNodeDescriptor)descriptor).getDartClass();
        if (dartClass == null || "Object".equals(dartClass.getName())) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSupertypesHierarchyTreeStructure", "buildChildren"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        List<TypeHierarchyItem> items = DartHierarchyUtil.getTypeHierarchyItems(dartClass);
        if (items.isEmpty()) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSupertypesHierarchyTreeStructure", "buildChildren"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        DartServerSupertypesHierarchyTreeStructure.addSuperClassHierarchy(Sets.newHashSet(), this.myProject, items, items.get(0), descriptor);
        Object[] objectArray = descriptor.getCachedChildren();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSupertypesHierarchyTreeStructure", "buildChildren"));
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addSuperClassHierarchy(@NotNull Set<TypeHierarchyItem> stackItems, @NotNull Project project, @NotNull List<TypeHierarchyItem> items, @NotNull TypeHierarchyItem item, @NotNull HierarchyNodeDescriptor descriptor) {
        if (stackItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackItems", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSupertypesHierarchyTreeStructure", "addSuperClassHierarchy"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSupertypesHierarchyTreeStructure", "addSuperClassHierarchy"));
        }
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSupertypesHierarchyTreeStructure", "addSuperClassHierarchy"));
        }
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSupertypesHierarchyTreeStructure", "addSuperClassHierarchy"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSupertypesHierarchyTreeStructure", "addSuperClassHierarchy"));
        }
        if (!stackItems.add(item)) {
            descriptor.setCachedChildren(ArrayUtil.EMPTY_OBJECT_ARRAY);
            return;
        }
        ArrayList superDescriptors = Lists.newArrayList();
        try {
            Integer superIndex = item.getSuperclass();
            if (superIndex != null) {
                DartServerSupertypesHierarchyTreeStructure.addSuperClassNode(stackItems, project, items, descriptor, superDescriptors, superIndex);
            }
            for (int index : item.getMixins()) {
                DartServerSupertypesHierarchyTreeStructure.addSuperClassNode(stackItems, project, items, descriptor, superDescriptors, index);
            }
            for (int index : item.getInterfaces()) {
                DartServerSupertypesHierarchyTreeStructure.addSuperClassNode(stackItems, project, items, descriptor, superDescriptors, index);
            }
        }
        finally {
            stackItems.remove(item);
        }
        descriptor.setCachedChildren((Object[])superDescriptors.toArray(new HierarchyNodeDescriptor[superDescriptors.size()]));
    }

    private static void addSuperClassNode(@NotNull Set<TypeHierarchyItem> stackItems, @NotNull Project project, @NotNull List<TypeHierarchyItem> items, @NotNull HierarchyNodeDescriptor parentNode, @NotNull List<HierarchyNodeDescriptor> descriptors, int index) {
        if (stackItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackItems", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSupertypesHierarchyTreeStructure", "addSuperClassNode"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSupertypesHierarchyTreeStructure", "addSuperClassNode"));
        }
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSupertypesHierarchyTreeStructure", "addSuperClassNode"));
        }
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSupertypesHierarchyTreeStructure", "addSuperClassNode"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerSupertypesHierarchyTreeStructure", "addSuperClassNode"));
        }
        TypeHierarchyItem superItem = items.get(index);
        if ("Object".equals(superItem.getClassElement().getName())) {
            return;
        }
        DartClass superClass = DartHierarchyUtil.findDartClass(project, superItem);
        DartTypeHierarchyNodeDescriptor superDescriptor = new DartTypeHierarchyNodeDescriptor(project, parentNode, superClass, false);
        descriptors.add(superDescriptor);
        DartServerSupertypesHierarchyTreeStructure.addSuperClassHierarchy(stackItems, project, items, superItem, superDescriptor);
    }
}

