/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.hierarchy.type;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.jetbrains.lang.dart.ide.hierarchy.DartHierarchyUtil;
import com.jetbrains.lang.dart.ide.hierarchy.type.DartServerSubtypesHierarchyTreeStructure;
import com.jetbrains.lang.dart.ide.hierarchy.type.DartTypeHierarchyNodeDescriptor;
import com.jetbrains.lang.dart.psi.DartClass;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.dartlang.analysis.server.protocol.TypeHierarchyItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DartServerTypeHierarchyTreeStructure
extends HierarchyTreeStructure {
    private final String myCurrentScopeType;

    public DartServerTypeHierarchyTreeStructure(Project project, DartClass dartClass, String currentScopeType) {
        super(project, DartServerTypeHierarchyTreeStructure.buildHierarchyElement(project, dartClass));
        this.myCurrentScopeType = currentScopeType;
        this.setBaseElement(this.myBaseDescriptor);
    }

    @NotNull
    protected Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerTypeHierarchyTreeStructure", "buildChildren"));
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerTypeHierarchyTreeStructure", "buildChildren"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    private static HierarchyNodeDescriptor buildHierarchyElement(@NotNull Project project, @NotNull DartClass dartClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerTypeHierarchyTreeStructure", "buildHierarchyElement"));
        }
        if (dartClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerTypeHierarchyTreeStructure", "buildHierarchyElement"));
        }
        if ("Object".equals(dartClass.getName())) {
            DartTypeHierarchyNodeDescriptor dartTypeHierarchyNodeDescriptor = new DartTypeHierarchyNodeDescriptor(project, null, dartClass, true);
            if (dartTypeHierarchyNodeDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerTypeHierarchyTreeStructure", "buildHierarchyElement"));
            }
            return dartTypeHierarchyNodeDescriptor;
        }
        List<TypeHierarchyItem> items = DartHierarchyUtil.getTypeHierarchyItems(dartClass);
        HierarchyNodeDescriptor superDescriptor = DartServerTypeHierarchyTreeStructure.buildSuperClassHierarchy(project, items);
        DartTypeHierarchyNodeDescriptor baseDescriptor = new DartTypeHierarchyNodeDescriptor(project, superDescriptor, dartClass, true);
        if (superDescriptor != null) {
            superDescriptor.setCachedChildren((Object[])new HierarchyNodeDescriptor[]{baseDescriptor});
        }
        if (!items.isEmpty()) {
            DartServerSubtypesHierarchyTreeStructure.addSubClassHierarchy(Sets.newHashSet(), project, items, items.get(0), baseDescriptor);
        }
        DartTypeHierarchyNodeDescriptor dartTypeHierarchyNodeDescriptor = baseDescriptor;
        if (dartTypeHierarchyNodeDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerTypeHierarchyTreeStructure", "buildHierarchyElement"));
        }
        return dartTypeHierarchyNodeDescriptor;
    }

    @Nullable
    private static HierarchyNodeDescriptor buildSuperClassHierarchy(@NotNull Project project, @NotNull List<TypeHierarchyItem> items) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerTypeHierarchyTreeStructure", "buildSuperClassHierarchy"));
        }
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerTypeHierarchyTreeStructure", "buildSuperClassHierarchy"));
        }
        DartTypeHierarchyNodeDescriptor descriptor = null;
        DartClass[] superClasses = DartServerTypeHierarchyTreeStructure.filterSuperClasses(project, items);
        for (int i = superClasses.length - 1; i >= 0; --i) {
            DartClass superClass = superClasses[i];
            DartTypeHierarchyNodeDescriptor newDescriptor = new DartTypeHierarchyNodeDescriptor(project, descriptor, superClass, false);
            if (descriptor != null) {
                descriptor.setCachedChildren(new HierarchyNodeDescriptor[]{newDescriptor});
            }
            descriptor = newDescriptor;
        }
        return descriptor;
    }

    @NotNull
    public static DartClass[] filterSuperClasses(@NotNull Project project, @NotNull List<TypeHierarchyItem> items) {
        TypeHierarchyItem superItem;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerTypeHierarchyTreeStructure", "filterSuperClasses"));
        }
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerTypeHierarchyTreeStructure", "filterSuperClasses"));
        }
        if (items.isEmpty()) {
            DartClass[] dartClassArray = new DartClass[]{};
            if (dartClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerTypeHierarchyTreeStructure", "filterSuperClasses"));
            }
            return dartClassArray;
        }
        HashSet seenItems = Sets.newHashSet();
        ArrayList superClasses = Lists.newArrayList();
        Integer superIndex = items.get(0).getSuperclass();
        while (superIndex != null && seenItems.add(superItem = items.get(superIndex))) {
            DartClass superClass = DartHierarchyUtil.findDartClass(project, superItem);
            if (superClass != null) {
                superClasses.add(superClass);
            }
            superIndex = superItem.getSuperclass();
        }
        DartClass[] dartClassArray = superClasses.toArray(new DartClass[superClasses.size()]);
        if (dartClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerTypeHierarchyTreeStructure", "filterSuperClasses"));
        }
        return dartClassArray;
    }
}

