/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.hierarchy.type;

import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.TypeHierarchyBrowserBase;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.lang.dart.ide.hierarchy.DartHierarchyUtil;
import com.jetbrains.lang.dart.ide.hierarchy.type.DartServerSubtypesHierarchyTreeStructure;
import com.jetbrains.lang.dart.ide.hierarchy.type.DartServerSupertypesHierarchyTreeStructure;
import com.jetbrains.lang.dart.ide.hierarchy.type.DartServerTypeHierarchyTreeStructure;
import com.jetbrains.lang.dart.ide.hierarchy.type.DartTypeHierarchyNodeDescriptor;
import com.jetbrains.lang.dart.psi.DartClass;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartTypeHierarchyBrowser
extends TypeHierarchyBrowserBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.lang.dart.ide.hierarchy.type.DartTypeHierarchyBrowser");

    public DartTypeHierarchyBrowser(Project project, DartClass dartClass) {
        super(project, (PsiElement)dartClass);
    }

    protected boolean isInterface(PsiElement psiElement) {
        return false;
    }

    protected void createTrees(@NotNull Map<String, JTree> trees) {
        if (trees == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trees", "com/jetbrains/lang/dart/ide/hierarchy/type/DartTypeHierarchyBrowser", "createTrees"));
        }
        this.createTreeAndSetupCommonActions(trees, "DartClassHierarchyPopupMenu");
    }

    @NotNull
    protected TypeHierarchyBrowserBase.BaseOnThisTypeAction createBaseOnThisAction() {
        BaseOnThisTypeAction baseOnThisTypeAction = new BaseOnThisTypeAction();
        if (baseOnThisTypeAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/type/DartTypeHierarchyBrowser", "createBaseOnThisAction"));
        }
        return baseOnThisTypeAction;
    }

    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/lang/dart/ide/hierarchy/type/DartTypeHierarchyBrowser", "getElementFromDescriptor"));
        }
        if (!(descriptor instanceof DartTypeHierarchyNodeDescriptor)) {
            return null;
        }
        return ((DartTypeHierarchyNodeDescriptor)descriptor).getDartClass();
    }

    @Nullable
    protected JPanel createLegendPanel() {
        return null;
    }

    protected boolean isApplicableElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/hierarchy/type/DartTypeHierarchyBrowser", "isApplicableElement"));
        }
        return element instanceof DartClass;
    }

    protected Comparator<NodeDescriptor> getComparator() {
        return DartHierarchyUtil.getComparator(this.myProject);
    }

    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String typeName, @NotNull PsiElement psiElement) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/jetbrains/lang/dart/ide/hierarchy/type/DartTypeHierarchyBrowser", "createHierarchyTreeStructure"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/lang/dart/ide/hierarchy/type/DartTypeHierarchyBrowser", "createHierarchyTreeStructure"));
        }
        if (SUPERTYPES_HIERARCHY_TYPE.equals(typeName)) {
            return new DartServerSupertypesHierarchyTreeStructure(this.myProject, (DartClass)psiElement);
        }
        if (SUBTYPES_HIERARCHY_TYPE.equals(typeName)) {
            return new DartServerSubtypesHierarchyTreeStructure(this.myProject, (DartClass)psiElement, this.getCurrentScopeType());
        }
        if (TYPE_HIERARCHY_TYPE.equals(typeName)) {
            return new DartServerTypeHierarchyTreeStructure(this.myProject, (DartClass)psiElement, this.getCurrentScopeType());
        }
        LOG.error("unexpected type: " + typeName);
        return null;
    }

    protected boolean canBeDeleted(PsiElement psiElement) {
        return psiElement instanceof DartClass;
    }

    protected String getQualifiedName(PsiElement psiElement) {
        if (psiElement instanceof DartClass) {
            return ((DartClass)psiElement).getName();
        }
        return "";
    }

    public static class BaseOnThisTypeAction
    extends TypeHierarchyBrowserBase.BaseOnThisTypeAction {
        protected boolean isEnabled(@NotNull HierarchyBrowserBaseEx browser, @NotNull PsiElement psiElement) {
            if (browser == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/jetbrains/lang/dart/ide/hierarchy/type/DartTypeHierarchyBrowser$BaseOnThisTypeAction", "isEnabled"));
            }
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/lang/dart/ide/hierarchy/type/DartTypeHierarchyBrowser$BaseOnThisTypeAction", "isEnabled"));
            }
            return super.isEnabled(browser, psiElement) && !"Object".equals(((DartClass)psiElement).getName());
        }
    }
}

