/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.hierarchy.type;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.ui.LayeredIcon;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DartTypeHierarchyNodeDescriptor
extends HierarchyNodeDescriptor {
    public DartTypeHierarchyNodeDescriptor(@NotNull Project project, @Nullable HierarchyNodeDescriptor parentDescriptor, @NotNull DartClass dartClass, boolean isBase) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/hierarchy/type/DartTypeHierarchyNodeDescriptor", "<init>"));
        }
        if (dartClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/ide/hierarchy/type/DartTypeHierarchyNodeDescriptor", "<init>"));
        }
        super(project, (NodeDescriptor)parentDescriptor, (PsiElement)dartClass, isBase);
    }

    @Nullable
    public final DartClass getDartClass() {
        PsiElement element = this.getPsiElement();
        return element instanceof DartClass ? (DartClass)element : null;
    }

    public final boolean update() {
        boolean changes = super.update();
        DartClass dartClass = this.getDartClass();
        if (dartClass == null) {
            String invalidPrefix = IdeBundle.message((String)"node.hierarchy.invalid", (Object[])new Object[0]);
            if (!this.myHighlightedText.getText().startsWith(invalidPrefix)) {
                this.myHighlightedText.getBeginning().addText(invalidPrefix, HierarchyNodeDescriptor.getInvalidPrefixAttributes());
            }
            return true;
        }
        if (changes && this.myIsBase) {
            LayeredIcon icon = new LayeredIcon(2);
            icon.setIcon(this.getIcon(), 0);
            icon.setIcon(AllIcons.Hierarchy.Base, 1, -AllIcons.Hierarchy.Base.getIconWidth() / 2, 0);
            this.setIcon((Icon)icon);
        }
        CompositeAppearance oldText = this.myHighlightedText;
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes classNameAttributes = null;
        if (this.myColor != null) {
            classNameAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        String libraryName = DartResolveUtil.getLibraryName(dartClass.getContainingFile());
        this.myHighlightedText.getEnding().addText(dartClass.getName(), classNameAttributes);
        this.myHighlightedText.getEnding().addText(" (" + libraryName + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes = true;
        }
        return changes;
    }
}

