/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.hierarchy.type;

import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.TypeHierarchyBrowserBase;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.ide.hierarchy.type.DartTypeHierarchyBrowser;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartTypeHierarchyProvider
implements HierarchyProvider {
    @Nullable
    public DartClass getTarget(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/lang/dart/ide/hierarchy/type/DartTypeHierarchyProvider", "getTarget"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (project == null || editor == null) {
            return null;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        PsiElement psiElement = file == null ? null : file.findElementAt(editor.getCaretModel().getOffset());
        DartReference dartReference = (DartReference)PsiTreeUtil.getParentOfType((PsiElement)psiElement, DartReference.class);
        if (dartReference != null) {
            return dartReference.resolveDartClass().getDartClass();
        }
        return (DartClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, DartClass.class);
    }

    @NotNull
    public HierarchyBrowser createHierarchyBrowser(PsiElement target) {
        DartTypeHierarchyBrowser dartTypeHierarchyBrowser = new DartTypeHierarchyBrowser(target.getProject(), (DartClass)target);
        if (dartTypeHierarchyBrowser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/hierarchy/type/DartTypeHierarchyProvider", "createHierarchyBrowser"));
        }
        return dartTypeHierarchyBrowser;
    }

    public void browserActivated(@NotNull HierarchyBrowser hierarchyBrowser) {
        if (hierarchyBrowser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchyBrowser", "com/jetbrains/lang/dart/ide/hierarchy/type/DartTypeHierarchyProvider", "browserActivated"));
        }
        ((DartTypeHierarchyBrowser)hierarchyBrowser).changeView(TypeHierarchyBrowserBase.TYPE_HIERARCHY_TYPE);
    }
}

