/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.imports;

import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.assists.AssistUtils;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import org.dartlang.analysis.server.protocol.SourceFileEdit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartImportOptimizer
implements ImportOptimizer {
    @NotNull
    public Runnable processFile(final PsiFile file) {
        DartAnalysisServerService.getInstance(file.getProject()).serverReadyForRequest(file.getProject());
        ImportOptimizer.CollectingInfoRunnable collectingInfoRunnable = new ImportOptimizer.CollectingInfoRunnable(){
            private boolean myFileChanged = false;

            public void run() {
                VirtualFile vFile = DartResolveUtil.getRealVirtualFile(file);
                if (vFile != null) {
                    String filePath = vFile.getPath();
                    SourceFileEdit fileEdit = DartAnalysisServerService.getInstance(file.getProject()).edit_organizeDirectives(filePath);
                    if (fileEdit != null) {
                        this.myFileChanged = AssistUtils.applyFileEdit(file.getProject(), fileEdit);
                    }
                }
            }

            @Nullable
            public String getUserNotificationInfo() {
                return this.myFileChanged ? DartBundle.message("organized.directives", new Object[0]) : null;
            }
        };
        if (collectingInfoRunnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/imports/DartImportOptimizer", "processFile"));
        }
        return collectingInfoRunnable;
    }

    public boolean supports(PsiFile file) {
        return file instanceof DartFile;
    }
}

