/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.lang.dart.ide.index.DartFileIndexData;
import com.jetbrains.lang.dart.ide.index.DartIndexUtil;
import com.jetbrains.lang.dart.ide.index.DartInputFilter;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DartClassIndex
extends ScalarIndexExtension<String> {
    public static final ID<String, Void> DART_CLASS_INDEX = ID.create((String)"DartClassIndex");
    private DataIndexer<String, Void, FileContent> myDataIndexer = new MyDataIndexer();

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = DART_CLASS_INDEX;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartClassIndex", "getName"));
        }
        return iD;
    }

    public int getVersion() {
        return 23;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = this.myDataIndexer;
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartClassIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartClassIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DartInputFilter dartInputFilter = DartInputFilter.INSTANCE;
        if (dartInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartClassIndex", "getInputFilter"));
        }
        return dartInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public static Collection<String> getNames(Project project) {
        return FileBasedIndex.getInstance().getAllKeys(DART_CLASS_INDEX, project);
    }

    public static List<DartComponentName> getItemsByName(String name, Project project, GlobalSearchScope searchScope) {
        Collection files = FileBasedIndex.getInstance().getContainingFiles(DART_CLASS_INDEX, (Object)name, searchScope);
        THashSet result = new THashSet();
        for (VirtualFile vFile : files) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
            for (PsiElement root : DartResolveUtil.findDartRoots(psiFile)) {
                for (DartClass component : DartResolveUtil.getClassDeclarations(root)) {
                    if (!name.equals(component.getName())) continue;
                    result.add(component.getComponentName());
                }
            }
        }
        return new ArrayList<DartComponentName>((Collection<DartComponentName>)result);
    }

    private static class MyDataIndexer
    implements DataIndexer<String, Void, FileContent> {
        private MyDataIndexer() {
        }

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/jetbrains/lang/dart/ide/index/DartClassIndex$MyDataIndexer", "map"));
            }
            DartFileIndexData indexData = DartIndexUtil.indexFile(inputData);
            THashMap result = new THashMap();
            for (String componentName : indexData.getClassNames()) {
                result.put(componentName, null);
            }
            THashMap tHashMap = result;
            if (tHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartClassIndex$MyDataIndexer", "map"));
            }
            return tHashMap;
        }
    }
}

