/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.index;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.lang.dart.ide.index.DartComponentInfo;
import com.jetbrains.lang.dart.ide.index.DartComponentInfoExternalizer;
import com.jetbrains.lang.dart.ide.index.DartIndexUtil;
import com.jetbrains.lang.dart.ide.index.DartInputFilter;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartComponentIndex
extends FileBasedIndexExtension<String, DartComponentInfo> {
    public static final ID<String, DartComponentInfo> DART_COMPONENT_INDEX = ID.create((String)"DartComponentIndex");
    private final DataIndexer<String, DartComponentInfo, FileContent> myIndexer = new MyDataIndexer();
    private final DataExternalizer<DartComponentInfo> myExternalizer = new DartComponentInfoExternalizer();

    @NotNull
    public ID<String, DartComponentInfo> getName() {
        ID<String, DartComponentInfo> iD = DART_COMPONENT_INDEX;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartComponentIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, DartComponentInfo, FileContent> getIndexer() {
        DataIndexer<String, DartComponentInfo, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartComponentIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartComponentIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<DartComponentInfo> getValueExternalizer() {
        DataExternalizer<DartComponentInfo> dataExternalizer = this.myExternalizer;
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartComponentIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DartInputFilter dartInputFilter = DartInputFilter.INSTANCE;
        if (dartInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartComponentIndex", "getInputFilter"));
        }
        return dartInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 23;
    }

    public static Collection<VirtualFile> getAllFiles(@NotNull String componentName, @NotNull GlobalSearchScope scope) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/jetbrains/lang/dart/ide/index/DartComponentIndex", "getAllFiles"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/lang/dart/ide/index/DartComponentIndex", "getAllFiles"));
        }
        return FileBasedIndex.getInstance().getContainingFiles(DART_COMPONENT_INDEX, (Object)componentName, scope);
    }

    public static void processAllComponents(@NotNull GlobalSearchScope scope, @Nullable Condition<String> nameFilter, @NotNull PairProcessor<String, DartComponentInfo> processor) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/lang/dart/ide/index/DartComponentIndex", "processAllComponents"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/lang/dart/ide/index/DartComponentIndex", "processAllComponents"));
        }
        Processor keysProcessor = componentName -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/lang/dart/ide/index/DartComponentIndex", "lambda$processAllComponents$1"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/lang/dart/ide/index/DartComponentIndex", "lambda$processAllComponents$1"));
            }
            if (nameFilter != null && !nameFilter.value(componentName)) {
                return true;
            }
            return DartComponentIndex.processComponentsByName(componentName, scope, (Processor<DartComponentInfo>)((Processor)info -> {
                if (processor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/lang/dart/ide/index/DartComponentIndex", "lambda$null$0"));
                }
                return processor.process(componentName, info);
            }));
        };
        FileBasedIndex.getInstance().processAllKeys(DART_COMPONENT_INDEX, keysProcessor, scope, null);
    }

    public static boolean processComponentsByName(@NotNull String componentName, @NotNull GlobalSearchScope scope, final @NotNull Processor<DartComponentInfo> processor) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/jetbrains/lang/dart/ide/index/DartComponentIndex", "processComponentsByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/lang/dart/ide/index/DartComponentIndex", "processComponentsByName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/lang/dart/ide/index/DartComponentIndex", "processComponentsByName"));
        }
        FileBasedIndex.ValueProcessor<DartComponentInfo> valueProcessor = new FileBasedIndex.ValueProcessor<DartComponentInfo>(){

            public boolean process(VirtualFile file, DartComponentInfo value) {
                return processor.process((Object)value);
            }
        };
        return FileBasedIndex.getInstance().processValues(DART_COMPONENT_INDEX, (Object)componentName, null, (FileBasedIndex.ValueProcessor)valueProcessor, scope);
    }

    private static class MyDataIndexer
    implements DataIndexer<String, DartComponentInfo, FileContent> {
        private MyDataIndexer() {
        }

        @NotNull
        public Map<String, DartComponentInfo> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/jetbrains/lang/dart/ide/index/DartComponentIndex$MyDataIndexer", "map"));
            }
            Map<String, DartComponentInfo> map = DartIndexUtil.indexFile(inputData).getComponentInfoMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartComponentIndex$MyDataIndexer", "map"));
            }
            return map;
        }
    }
}

