/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.index;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.ide.index.DartComponentInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class DartComponentInfoExternalizer
implements DataExternalizer<DartComponentInfo> {
    public void save(@NotNull DataOutput out, @NotNull DartComponentInfo componentInfo) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/jetbrains/lang/dart/ide/index/DartComponentInfoExternalizer", "save"));
        }
        if (componentInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentInfo", "com/jetbrains/lang/dart/ide/index/DartComponentInfoExternalizer", "save"));
        }
        DartComponentType dartComponentType = componentInfo.getComponentType();
        int key = dartComponentType == null ? -1 : dartComponentType.getKey();
        DataInputOutputUtil.writeINT((DataOutput)out, (int)key);
        String libraryName = componentInfo.getLibraryName();
        out.writeBoolean(libraryName != null);
        if (libraryName != null) {
            IOUtil.writeUTF((DataOutput)out, (String)libraryName);
        }
    }

    public DartComponentInfo read(@NotNull DataInput in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/jetbrains/lang/dart/ide/index/DartComponentInfoExternalizer", "read"));
        }
        int componentTypeKey = DataInputOutputUtil.readINT((DataInput)in);
        boolean hasLibraryName = in.readBoolean();
        String libraryName = hasLibraryName ? IOUtil.readUTF((DataInput)in) : null;
        return new DartComponentInfo(DartComponentType.valueOf(componentTypeKey), libraryName);
    }
}

