/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.index;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.ide.index.DartComponentInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DartComponentInfoListExternalizer
implements DataExternalizer<List<DartComponentInfo>> {
    public void save(@NotNull DataOutput out, @NotNull List<DartComponentInfo> infos) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/jetbrains/lang/dart/ide/index/DartComponentInfoListExternalizer", "save"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/jetbrains/lang/dart/ide/index/DartComponentInfoListExternalizer", "save"));
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)infos.size());
        for (DartComponentInfo componentInfo : infos) {
            DartComponentType dartComponentType = componentInfo.getComponentType();
            int key = dartComponentType == null ? -1 : dartComponentType.getKey();
            DataInputOutputUtil.writeINT((DataOutput)out, (int)key);
            String libraryName = componentInfo.getLibraryName();
            out.writeBoolean(libraryName != null);
            if (libraryName == null) continue;
            IOUtil.writeUTF((DataOutput)out, (String)libraryName);
        }
    }

    public List<DartComponentInfo> read(@NotNull DataInput in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/jetbrains/lang/dart/ide/index/DartComponentInfoListExternalizer", "read"));
        }
        int size = DataInputOutputUtil.readINT((DataInput)in);
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<DartComponentInfo> result = new ArrayList<DartComponentInfo>(size);
        for (int i = 0; i < size; ++i) {
            int componentTypeKey = DataInputOutputUtil.readINT((DataInput)in);
            boolean hasLibraryName = in.readBoolean();
            String libraryName = hasLibraryName ? IOUtil.readUTF((DataInput)in) : null;
            result.add(new DartComponentInfo(DartComponentType.valueOf(componentTypeKey), libraryName));
        }
        return result;
    }
}

