/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.lang.dart.ide.index.DartImportOrExportInfo;
import com.jetbrains.lang.dart.ide.index.DartIndexUtil;
import com.jetbrains.lang.dart.ide.index.DartInputFilter;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DartImportAndExportIndex
extends FileBasedIndexExtension<String, List<DartImportOrExportInfo>> {
    public static final ID<String, List<DartImportOrExportInfo>> DART_IMPORT_EXPORT_INDEX = ID.create((String)"DartImportIndex");
    private DataIndexer<String, List<DartImportOrExportInfo>, FileContent> myDataIndexer = new MyDataIndexer();

    @NotNull
    public ID<String, List<DartImportOrExportInfo>> getName() {
        ID<String, List<DartImportOrExportInfo>> iD = DART_IMPORT_EXPORT_INDEX;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartImportAndExportIndex", "getName"));
        }
        return iD;
    }

    public int getVersion() {
        return 23;
    }

    @NotNull
    public DataIndexer<String, List<DartImportOrExportInfo>, FileContent> getIndexer() {
        DataIndexer<String, List<DartImportOrExportInfo>, FileContent> dataIndexer = this.myDataIndexer;
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartImportAndExportIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartImportAndExportIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<List<DartImportOrExportInfo>> getValueExternalizer() {
        DataExternalizer<List<DartImportOrExportInfo>> dataExternalizer = new DataExternalizer<List<DartImportOrExportInfo>>(){

            public void save(@NotNull DataOutput out, @NotNull List<DartImportOrExportInfo> value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/jetbrains/lang/dart/ide/index/DartImportAndExportIndex$1", "save"));
                }
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/lang/dart/ide/index/DartImportAndExportIndex$1", "save"));
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value.size());
                for (DartImportOrExportInfo importOrExportInfo : value) {
                    IOUtil.writeUTF((DataOutput)out, (String)importOrExportInfo.getKind().name());
                    IOUtil.writeUTF((DataOutput)out, (String)importOrExportInfo.getUri());
                    IOUtil.writeUTF((DataOutput)out, (String)StringUtil.notNullize((String)importOrExportInfo.getImportPrefix()));
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)importOrExportInfo.getShowComponents().size());
                    for (String showComponentName : importOrExportInfo.getShowComponents()) {
                        IOUtil.writeUTF((DataOutput)out, (String)showComponentName);
                    }
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)importOrExportInfo.getHideComponents().size());
                    for (String hideComponentName : importOrExportInfo.getHideComponents()) {
                        IOUtil.writeUTF((DataOutput)out, (String)hideComponentName);
                    }
                }
            }

            @NotNull
            public List<DartImportOrExportInfo> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/jetbrains/lang/dart/ide/index/DartImportAndExportIndex$1", "read"));
                }
                int size = DataInputOutputUtil.readINT((DataInput)in);
                ArrayList<DartImportOrExportInfo> result = new ArrayList<DartImportOrExportInfo>(size);
                for (int i = 0; i < size; ++i) {
                    DartImportOrExportInfo.Kind kind = DartImportOrExportInfo.Kind.valueOf(IOUtil.readUTF((DataInput)in));
                    String uri = IOUtil.readUTF((DataInput)in);
                    String prefix = IOUtil.readUTF((DataInput)in);
                    int showSize = DataInputOutputUtil.readINT((DataInput)in);
                    THashSet showComponentNames = showSize == 0 ? Collections.emptySet() : new THashSet(showSize);
                    for (int j = 0; j < showSize; ++j) {
                        showComponentNames.add(IOUtil.readUTF((DataInput)in));
                    }
                    int hideSize = DataInputOutputUtil.readINT((DataInput)in);
                    THashSet hideComponentNames = hideSize == 0 ? Collections.emptySet() : new THashSet(hideSize);
                    for (int j = 0; j < hideSize; ++j) {
                        hideComponentNames.add(IOUtil.readUTF((DataInput)in));
                    }
                    result.add(new DartImportOrExportInfo(kind, uri, StringUtil.nullize((String)prefix), (Set<String>)showComponentNames, (Set<String>)hideComponentNames));
                }
                ArrayList<DartImportOrExportInfo> arrayList = result;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartImportAndExportIndex$1", "read"));
                }
                return arrayList;
            }
        };
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartImportAndExportIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DartInputFilter dartInputFilter = DartInputFilter.INSTANCE;
        if (dartInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartImportAndExportIndex", "getInputFilter"));
        }
        return dartInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public static List<DartImportOrExportInfo> getImportAndExportInfos(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/index/DartImportAndExportIndex", "getImportAndExportInfos"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/jetbrains/lang/dart/ide/index/DartImportAndExportIndex", "getImportAndExportInfos"));
        }
        ArrayList<DartImportOrExportInfo> result = new ArrayList<DartImportOrExportInfo>();
        for (List list : FileBasedIndex.getInstance().getValues(DART_IMPORT_EXPORT_INDEX, (Object)virtualFile.getName(), GlobalSearchScope.fileScope((Project)project, (VirtualFile)virtualFile))) {
            result.addAll(list);
        }
        ArrayList<DartImportOrExportInfo> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartImportAndExportIndex", "getImportAndExportInfos"));
        }
        return arrayList;
    }

    private static class MyDataIndexer
    implements DataIndexer<String, List<DartImportOrExportInfo>, FileContent> {
        private MyDataIndexer() {
        }

        @NotNull
        public Map<String, List<DartImportOrExportInfo>> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/jetbrains/lang/dart/ide/index/DartImportAndExportIndex$MyDataIndexer", "map"));
            }
            Map<String, List<DartImportOrExportInfo>> map = Collections.singletonMap(inputData.getFileName(), DartIndexUtil.indexFile(inputData).getImportAndExportInfos());
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartImportAndExportIndex$MyDataIndexer", "map"));
            }
            return map;
        }
    }
}

