/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.index;

import com.jetbrains.lang.dart.ide.index.DartShowHideInfo;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartImportOrExportInfo
implements DartShowHideInfo {
    @NotNull
    private final Kind myKind;
    @NotNull
    private final String myUri;
    @Nullable
    private final String myImportPrefix;
    @NotNull
    private final Set<String> myShowComponents;
    @NotNull
    private final Set<String> myHideComponents;

    public DartImportOrExportInfo(@NotNull Kind kind, @NotNull String uri, @Nullable String importPrefix, @NotNull Set<String> showComponents, @NotNull Set<String> hideComponents) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/lang/dart/ide/index/DartImportOrExportInfo", "<init>"));
        }
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "com/jetbrains/lang/dart/ide/index/DartImportOrExportInfo", "<init>"));
        }
        if (showComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "showComponents", "com/jetbrains/lang/dart/ide/index/DartImportOrExportInfo", "<init>"));
        }
        if (hideComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hideComponents", "com/jetbrains/lang/dart/ide/index/DartImportOrExportInfo", "<init>"));
        }
        this.myKind = kind;
        this.myUri = uri;
        this.myImportPrefix = kind == Kind.Export ? null : importPrefix;
        this.myShowComponents = showComponents;
        this.myHideComponents = hideComponents;
    }

    @NotNull
    public String getUri() {
        String string = this.myUri;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartImportOrExportInfo", "getUri"));
        }
        return string;
    }

    @NotNull
    public Kind getKind() {
        Kind kind = this.myKind;
        if (kind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartImportOrExportInfo", "getKind"));
        }
        return kind;
    }

    @Nullable
    public String getImportPrefix() {
        return this.myImportPrefix;
    }

    @Override
    @NotNull
    public Set<String> getShowComponents() {
        Set<String> set = this.myShowComponents;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartImportOrExportInfo", "getShowComponents"));
        }
        return set;
    }

    @Override
    @NotNull
    public Set<String> getHideComponents() {
        Set<String> set = this.myHideComponents;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartImportOrExportInfo", "getHideComponents"));
        }
        return set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DartImportOrExportInfo info = (DartImportOrExportInfo)o;
        if (this.myKind != info.myKind) {
            return false;
        }
        if (!this.myUri.equals(info.myUri)) {
            return false;
        }
        if (this.myImportPrefix != null ? !this.myImportPrefix.equals(info.myImportPrefix) : info.myImportPrefix != null) {
            return false;
        }
        if (!this.myShowComponents.equals(info.myShowComponents)) {
            return false;
        }
        return this.myHideComponents.equals(info.myHideComponents);
    }

    public int hashCode() {
        int result = this.myKind.hashCode();
        result = 31 * result + this.myUri.hashCode();
        result = 31 * result + (this.myImportPrefix != null ? this.myImportPrefix.hashCode() : 0);
        result = 31 * result + this.myShowComponents.hashCode();
        result = 31 * result + this.myHideComponents.hashCode();
        return result;
    }

    public static enum Kind {
        Import,
        Export;

    }
}

