/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.index;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.indexing.FileContent;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.ide.index.DartComponentInfo;
import com.jetbrains.lang.dart.ide.index.DartFileIndexData;
import com.jetbrains.lang.dart.ide.index.DartImportOrExportInfo;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartEnumConstantDeclaration;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartHideCombinator;
import com.jetbrains.lang.dart.psi.DartImportOrExportStatement;
import com.jetbrains.lang.dart.psi.DartImportStatement;
import com.jetbrains.lang.dart.psi.DartLibraryReferenceList;
import com.jetbrains.lang.dart.psi.DartPartOfStatement;
import com.jetbrains.lang.dart.psi.DartPartStatement;
import com.jetbrains.lang.dart.psi.DartShowCombinator;
import com.jetbrains.lang.dart.util.DartControlFlowUtil;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DartIndexUtil {
    public static final int INDEX_VERSION = 23;
    private static final Key<DartFileIndexData> ourDartCachesData = Key.create((String)"dart.caches.index.data");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DartFileIndexData indexFile(FileContent content) {
        DartFileIndexData indexData = (DartFileIndexData)content.getUserData(ourDartCachesData);
        if (indexData != null) {
            return indexData;
        }
        FileContent fileContent = content;
        synchronized (fileContent) {
            indexData = (DartFileIndexData)content.getUserData(ourDartCachesData);
            if (indexData != null) {
                return indexData;
            }
            indexData = DartIndexUtil.indexFileRoots(content.getPsiFile());
        }
        return indexData;
    }

    private static DartFileIndexData indexFileRoots(PsiFile psiFile) {
        DartFileIndexData result = new DartFileIndexData();
        result.setLibraryName(DartResolveUtil.getLibraryName(psiFile));
        result.setIsPart(PsiTreeUtil.getChildOfType((PsiElement)psiFile, DartPartOfStatement.class) != null);
        for (PsiElement rootElement : DartResolveUtil.findDartRoots(psiFile)) {
            PsiElement[] children = rootElement.getChildren();
            for (DartComponentName componentName : DartControlFlowUtil.getSimpleDeclarations(children, null, false)) {
                String name = componentName.getName();
                if (name == null) continue;
                result.addSymbol(name);
                PsiElement parent = componentName.getParent();
                DartComponentType type = DartComponentType.typeOf(parent);
                if (type != null) {
                    result.addComponentInfo(name, new DartComponentInfo(type, result.getLibraryName()));
                }
                if (!(parent instanceof DartClass)) continue;
                result.addClassName(name);
                if (((DartClass)parent).isEnum()) {
                    for (DartEnumConstantDeclaration enumConstantDeclaration : ((DartClass)parent).getEnumConstantDeclarationList()) {
                        result.addSymbol(enumConstantDeclaration.getName());
                    }
                    continue;
                }
                for (DartComponent subComponent : DartResolveUtil.getNamedSubComponents((DartClass)parent)) {
                    result.addSymbol(subComponent.getName());
                }
            }
            for (PsiElement child : children) {
                if (child instanceof DartImportOrExportStatement) {
                    DartIndexUtil.processImportOrExportStatement(result, (DartImportOrExportStatement)child);
                }
                if (!(child instanceof DartPartStatement)) continue;
                result.addPartUri(((DartPartStatement)child).getUriString());
            }
        }
        return result;
    }

    private static void processImportOrExportStatement(@NotNull DartFileIndexData result, @NotNull DartImportOrExportStatement importOrExportStatement) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/lang/dart/ide/index/DartIndexUtil", "processImportOrExportStatement"));
        }
        if (importOrExportStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importOrExportStatement", "com/jetbrains/lang/dart/ide/index/DartIndexUtil", "processImportOrExportStatement"));
        }
        String uri = importOrExportStatement.getUriString();
        THashSet showComponentNames = new THashSet();
        for (DartShowCombinator dartShowCombinator : importOrExportStatement.getShowCombinatorList()) {
            DartLibraryReferenceList libraryReferenceList = dartShowCombinator.getLibraryReferenceList();
            if (libraryReferenceList == null) continue;
            for (DartExpression dartExpression : libraryReferenceList.getLibraryComponentReferenceExpressionList()) {
                showComponentNames.add(dartExpression.getText());
            }
        }
        THashSet hideComponentNames = new THashSet();
        for (DartHideCombinator hideCombinator : importOrExportStatement.getHideCombinatorList()) {
            DartLibraryReferenceList libraryReferenceList = hideCombinator.getLibraryReferenceList();
            if (libraryReferenceList == null) continue;
            for (DartExpression dartExpression : libraryReferenceList.getLibraryComponentReferenceExpressionList()) {
                hideComponentNames.add(dartExpression.getText());
            }
        }
        DartComponentName dartComponentName = importOrExportStatement instanceof DartImportStatement ? ((DartImportStatement)importOrExportStatement).getImportPrefix() : null;
        String importPrefix = dartComponentName != null ? dartComponentName.getName() : null;
        DartImportOrExportInfo.Kind kind = importOrExportStatement instanceof DartImportStatement ? DartImportOrExportInfo.Kind.Import : DartImportOrExportInfo.Kind.Export;
        result.addImportInfo(new DartImportOrExportInfo(kind, uri, importPrefix, (Set<String>)showComponentNames, (Set<String>)hideComponentNames));
        result.addComponentInfo(importPrefix, new DartComponentInfo(DartComponentType.LABEL, null));
    }
}

