/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.index;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.ide.index.DartFileIndexData;
import com.jetbrains.lang.dart.ide.index.DartIndexUtil;
import com.jetbrains.lang.dart.ide.index.DartInputFilter;
import com.jetbrains.lang.dart.psi.DartArgumentList;
import com.jetbrains.lang.dart.psi.DartArguments;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.psi.DartMapLiteralEntry;
import com.jetbrains.lang.dart.psi.DartNewExpression;
import com.jetbrains.lang.dart.psi.DartRecursiveVisitor;
import com.jetbrains.lang.dart.psi.DartStringLiteralExpression;
import com.jetbrains.lang.dart.psi.DartType;
import com.jetbrains.lang.dart.sdk.DartSdk;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartLibraryIndex
extends ScalarIndexExtension<String> {
    public static final ID<String, Void> DART_LIBRARY_INDEX = ID.create((String)"DartLibraryIndex");
    private static final Key<Pair<Long, BidirectionalMap<String, String>>> LIBRARIES_TIME_AND_MAP_KEY = Key.create((String)"dart.internal.libraries");
    private DataIndexer<String, Void, FileContent> myDataIndexer = new MyDataIndexer();

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = DART_LIBRARY_INDEX;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartLibraryIndex", "getName"));
        }
        return iD;
    }

    public int getVersion() {
        return 23;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = this.myDataIndexer;
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartLibraryIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartLibraryIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DartInputFilter dartInputFilter = DartInputFilter.INSTANCE;
        if (dartInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartLibraryIndex", "getInputFilter"));
        }
        return dartInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public static Collection<VirtualFile> getFilesByLibName(@NotNull GlobalSearchScope scope, @NotNull String libraryName) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/lang/dart/ide/index/DartLibraryIndex", "getFilesByLibName"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/jetbrains/lang/dart/ide/index/DartLibraryIndex", "getFilesByLibName"));
        }
        return FileBasedIndex.getInstance().getContainingFiles(DART_LIBRARY_INDEX, (Object)libraryName, scope);
    }

    @Nullable
    public static String getSdkLibUriByRelativePath(@NotNull Project project, @NotNull String relativePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/index/DartLibraryIndex", "getSdkLibUriByRelativePath"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/jetbrains/lang/dart/ide/index/DartLibraryIndex", "getSdkLibUriByRelativePath"));
        }
        DartSdk sdk = DartSdk.getDartSdk(project);
        List libNames = sdk == null ? null : DartLibraryIndex.getSdkLibUriToRelativePathMap(project, sdk.getHomePath()).getKeysByValue((Object)relativePath);
        return libNames == null || libNames.isEmpty() ? null : (String)libNames.get(0);
    }

    @Nullable
    public static VirtualFile getSdkLibByUri(@NotNull Project project, @NotNull String sdkLibUri) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/index/DartLibraryIndex", "getSdkLibByUri"));
        }
        if (sdkLibUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkLibUri", "com/jetbrains/lang/dart/ide/index/DartLibraryIndex", "getSdkLibByUri"));
        }
        DartSdk sdk = DartSdk.getDartSdk(project);
        String relativeLibPath = sdk == null ? null : (String)DartLibraryIndex.getSdkLibUriToRelativePathMap(project, sdk.getHomePath()).get((Object)sdkLibUri);
        return relativeLibPath == null ? null : LocalFileSystem.getInstance().findFileByPath(sdk.getHomePath() + "/lib/" + relativeLibPath);
    }

    @NotNull
    public static BidirectionalMap<String, String> getSdkLibUriToRelativePathMap(@NotNull Project project, @NotNull String sdkHomePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/index/DartLibraryIndex", "getSdkLibUriToRelativePathMap"));
        }
        if (sdkHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHomePath", "com/jetbrains/lang/dart/ide/index/DartLibraryIndex", "getSdkLibUriToRelativePathMap"));
        }
        VirtualFile librariesDartFile = LocalFileSystem.getInstance().findFileByPath(sdkHomePath + "/lib/_internal/libraries.dart");
        if (librariesDartFile == null) {
            BidirectionalMap bidirectionalMap = new BidirectionalMap();
            if (bidirectionalMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartLibraryIndex", "getSdkLibUriToRelativePathMap"));
            }
            return bidirectionalMap;
        }
        Pair data = (Pair)librariesDartFile.getUserData(LIBRARIES_TIME_AND_MAP_KEY);
        Long cachedTimestamp = data == null ? null : (Long)data.first;
        long modificationCount = librariesDartFile.getModificationCount();
        if (cachedTimestamp != null && cachedTimestamp.equals(modificationCount)) {
            BidirectionalMap bidirectionalMap = (BidirectionalMap)data.second;
            if (bidirectionalMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartLibraryIndex", "getSdkLibUriToRelativePathMap"));
            }
            return bidirectionalMap;
        }
        BidirectionalMap bidirectionalMap = (BidirectionalMap)ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/index/DartLibraryIndex", "lambda$getSdkLibUriToRelativePathMap$0"));
            }
            try {
                String contents = StringUtil.convertLineSeparators((String)VfsUtilCore.loadText((VirtualFile)librariesDartFile));
                PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("libraries.dart", DartLanguage.INSTANCE, (CharSequence)contents);
                if (!(psiFile instanceof DartFile)) {
                    return new BidirectionalMap();
                }
                Pair data1 = Pair.create((Object)modificationCount, DartLibraryIndex.computeSdkLibUriToRelativePathMap((DartFile)psiFile));
                librariesDartFile.putUserData(LIBRARIES_TIME_AND_MAP_KEY, (Object)data1);
                return (BidirectionalMap)data1.second;
            }
            catch (IOException e) {
                return new BidirectionalMap();
            }
        });
        if (bidirectionalMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartLibraryIndex", "getSdkLibUriToRelativePathMap"));
        }
        return bidirectionalMap;
    }

    private static BidirectionalMap<String, String> computeSdkLibUriToRelativePathMap(@NotNull DartFile librariesDartFile) {
        if (librariesDartFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "librariesDartFile", "com/jetbrains/lang/dart/ide/index/DartLibraryIndex", "computeSdkLibUriToRelativePathMap"));
        }
        final BidirectionalMap result = new BidirectionalMap();
        librariesDartFile.acceptChildren(new DartRecursiveVisitor(){

            @Override
            public void visitMapLiteralEntry(@NotNull DartMapLiteralEntry mapLiteralEntry) {
                String libraryRelativePath;
                if (mapLiteralEntry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapLiteralEntry", "com/jetbrains/lang/dart/ide/index/DartLibraryIndex$1", "visitMapLiteralEntry"));
                }
                List<DartExpression> expressions = mapLiteralEntry.getExpressionList();
                if (expressions.size() != 2 || !(expressions.get(0) instanceof DartStringLiteralExpression) || !(expressions.get(1) instanceof DartNewExpression)) {
                    return;
                }
                DartStringLiteralExpression keyExpression = (DartStringLiteralExpression)expressions.get(0);
                DartNewExpression newExpression = (DartNewExpression)expressions.get(1);
                String libraryName = StringUtil.unquoteString((String)keyExpression.getText());
                DartType dartType = newExpression.getType();
                if (dartType == null || !"LibraryInfo".equals(dartType.getText())) {
                    return;
                }
                DartArguments arguments = newExpression.getArguments();
                DartArgumentList argumentList = arguments != null ? arguments.getArgumentList() : null;
                List<DartExpression> expressionList = argumentList != null ? argumentList.getExpressionList() : null;
                DartExpression firstExpression = expressionList == null || expressionList.isEmpty() ? null : expressionList.get(0);
                String string = libraryRelativePath = firstExpression instanceof DartStringLiteralExpression ? StringUtil.unquoteString((String)firstExpression.getText()) : null;
                if (libraryRelativePath != null) {
                    String libraryUri = "dart:" + libraryName;
                    result.put((Object)libraryUri, (Object)libraryRelativePath);
                }
            }
        });
        return result;
    }

    private static class MyDataIndexer
    implements DataIndexer<String, Void, FileContent> {
        private MyDataIndexer() {
        }

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/jetbrains/lang/dart/ide/index/DartLibraryIndex$MyDataIndexer", "map"));
            }
            DartFileIndexData indexData = DartIndexUtil.indexFile(inputData);
            Map<String, Void> map = indexData.isPart() ? Collections.emptyMap() : Collections.singletonMap(indexData.getLibraryName(), null);
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartLibraryIndex$MyDataIndexer", "map"));
            }
            return map;
        }
    }
}

