/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.lang.dart.ide.index.DartIndexUtil;
import com.jetbrains.lang.dart.ide.index.DartInputFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DartPartUriIndex
extends FileBasedIndexExtension<String, List<String>> {
    public static final ID<String, List<String>> DART_PATH_INDEX = ID.create((String)"DartPathIndex");
    private DataIndexer<String, List<String>, FileContent> myDataIndexer = new MyDataIndexer();

    @NotNull
    public ID<String, List<String>> getName() {
        ID<String, List<String>> iD = DART_PATH_INDEX;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartPartUriIndex", "getName"));
        }
        return iD;
    }

    public int getVersion() {
        return 23;
    }

    @NotNull
    public DataIndexer<String, List<String>, FileContent> getIndexer() {
        DataIndexer<String, List<String>, FileContent> dataIndexer = this.myDataIndexer;
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartPartUriIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartPartUriIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<List<String>> getValueExternalizer() {
        DataExternalizer<List<String>> dataExternalizer = new DataExternalizer<List<String>>(){

            public void save(@NotNull DataOutput out, List<String> value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/jetbrains/lang/dart/ide/index/DartPartUriIndex$1", "save"));
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value.size());
                for (String path : value) {
                    IOUtil.writeUTF((DataOutput)out, (String)path);
                }
            }

            public List<String> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/jetbrains/lang/dart/ide/index/DartPartUriIndex$1", "read"));
                }
                int size = DataInputOutputUtil.readINT((DataInput)in);
                ArrayList<String> result = new ArrayList<String>(size);
                for (int i = 0; i < size; ++i) {
                    result.add(IOUtil.readUTF((DataInput)in));
                }
                return result;
            }
        };
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartPartUriIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DartInputFilter dartInputFilter = DartInputFilter.INSTANCE;
        if (dartInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartPartUriIndex", "getInputFilter"));
        }
        return dartInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public static List<String> getPartUris(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/index/DartPartUriIndex", "getPartUris"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/jetbrains/lang/dart/ide/index/DartPartUriIndex", "getPartUris"));
        }
        ArrayList<String> result = new ArrayList<String>();
        for (List list : FileBasedIndex.getInstance().getValues(DART_PATH_INDEX, (Object)virtualFile.getName(), GlobalSearchScope.fileScope((Project)project, (VirtualFile)virtualFile))) {
            result.addAll(list);
        }
        return result;
    }

    private static class MyDataIndexer
    implements DataIndexer<String, List<String>, FileContent> {
        private MyDataIndexer() {
        }

        @NotNull
        public Map<String, List<String>> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/jetbrains/lang/dart/ide/index/DartPartUriIndex$MyDataIndexer", "map"));
            }
            Map<String, List<String>> map = Collections.singletonMap(inputData.getFileName(), DartIndexUtil.indexFile(inputData).getPartUris());
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartPartUriIndex$MyDataIndexer", "map"));
            }
            return map;
        }
    }
}

