/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.lang.dart.ide.index.DartIndexUtil;
import com.jetbrains.lang.dart.ide.index.DartInputFilter;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartVarDeclarationList;
import com.jetbrains.lang.dart.psi.DartVarDeclarationListPart;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DartSymbolIndex
extends ScalarIndexExtension<String> {
    public static final ID<String, Void> DART_SYMBOL_INDEX = ID.create((String)"DartSymbolIndex");
    private DataIndexer<String, Void, FileContent> myDataIndexer = new MyDataIndexer();

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = DART_SYMBOL_INDEX;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartSymbolIndex", "getName"));
        }
        return iD;
    }

    public int getVersion() {
        return 23;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = this.myDataIndexer;
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartSymbolIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartSymbolIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DartInputFilter dartInputFilter = DartInputFilter.INSTANCE;
        if (dartInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartSymbolIndex", "getInputFilter"));
        }
        return dartInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public static String[] getAllSymbols(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/lang/dart/ide/index/DartSymbolIndex", "getAllSymbols"));
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        FileBasedIndex.getInstance().processAllKeys(DART_SYMBOL_INDEX, (Processor)processor, scope, null);
        return ArrayUtil.toStringArray((Collection)processor.getResults());
    }

    public static List<DartComponentName> getItemsByName(final @NotNull String name, @NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/ide/index/DartSymbolIndex", "getItemsByName"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/index/DartSymbolIndex", "getItemsByName"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/jetbrains/lang/dart/ide/index/DartSymbolIndex", "getItemsByName"));
        }
        Collection files = FileBasedIndex.getInstance().getContainingFiles(DART_SYMBOL_INDEX, (Object)name, searchScope);
        THashSet result = new THashSet();
        for (VirtualFile vFile : files) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
            for (PsiElement root : DartResolveUtil.findDartRoots(psiFile)) {
                DartSymbolIndex.processComponents(root, new PsiElementProcessor<DartComponent>((Set)result){
                    final /* synthetic */ Set val$result;
                    {
                        this.val$result = set;
                    }

                    public boolean execute(@NotNull DartComponent component) {
                        if (component == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/lang/dart/ide/index/DartSymbolIndex$1", "execute"));
                        }
                        if (name.equals(component.getName())) {
                            this.val$result.add(component.getComponentName());
                        }
                        return true;
                    }
                });
            }
        }
        return new ArrayList<DartComponentName>((Collection<DartComponentName>)result);
    }

    private static void processComponents(PsiElement context, PsiElementProcessor<DartComponent> processor) {
        DartVarDeclarationList[] varLists;
        DartComponent[] components = (DartComponent[])PsiTreeUtil.getChildrenOfType((PsiElement)context, DartComponent.class);
        if (components != null) {
            for (DartComponent component : components) {
                if (DartSymbolIndex.processComponent(processor, component)) continue;
                return;
            }
        }
        if ((varLists = (DartVarDeclarationList[])PsiTreeUtil.getChildrenOfType((PsiElement)context, DartVarDeclarationList.class)) != null) {
            for (DartVarDeclarationList varList : varLists) {
                if (!DartSymbolIndex.processComponent(processor, varList.getVarAccessDeclaration())) {
                    return;
                }
                for (DartVarDeclarationListPart part : varList.getVarDeclarationListPartList()) {
                    if (DartSymbolIndex.processComponent(processor, part)) continue;
                    return;
                }
            }
        }
    }

    private static boolean processComponent(PsiElementProcessor<DartComponent> processor, DartComponent component) {
        String componentName = component.getName();
        if (componentName == null) {
            return true;
        }
        if (!processor.execute((PsiElement)component)) {
            return false;
        }
        if (component instanceof DartClass) {
            for (DartComponent subComponent : DartResolveUtil.getNamedSubComponents((DartClass)component)) {
                if (subComponent.isConstructor() && componentName.equals(subComponent.getName()) || processor.execute((PsiElement)subComponent)) continue;
                return false;
            }
        }
        return true;
    }

    private static class MyDataIndexer
    implements DataIndexer<String, Void, FileContent> {
        private MyDataIndexer() {
        }

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/jetbrains/lang/dart/ide/index/DartSymbolIndex$MyDataIndexer", "map"));
            }
            List<String> symbols = DartIndexUtil.indexFile(inputData).getSymbols();
            THashMap result = new THashMap();
            for (String symbol : symbols) {
                result.put(symbol, null);
            }
            THashMap tHashMap = result;
            if (tHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/index/DartSymbolIndex$MyDataIndexer", "map"));
            }
            return tHashMap;
        }
    }
}

