/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.info;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartFormalParameterList;
import com.jetbrains.lang.dart.psi.DartNormalFormalParameter;
import com.jetbrains.lang.dart.util.DartGenericSpecialization;
import com.jetbrains.lang.dart.util.DartPresentableUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DartParameterDescription {
    private final String myText;

    public DartParameterDescription(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/lang/dart/ide/info/DartParameterDescription", "<init>"));
        }
        this.myText = text;
    }

    public static DartParameterDescription[] getParameters(DartComponent element, DartGenericSpecialization specialization) {
        DartFormalParameterList parameterList = (DartFormalParameterList)PsiTreeUtil.getChildOfType((PsiElement)element, DartFormalParameterList.class);
        if (parameterList == null) {
            return new DartParameterDescription[0];
        }
        List<DartNormalFormalParameter> list = parameterList.getNormalFormalParameterList();
        DartParameterDescription[] result = new DartParameterDescription[list.size()];
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            result[i] = new DartParameterDescription(DartPresentableUtil.getPresentableNormalFormalParameter(list.get(i), specialization));
        }
        return result;
    }

    public String toString() {
        return this.myText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DartParameterDescription that = (DartParameterDescription)o;
        return !(this.myText != null ? !this.myText.equals(that.myText) : that.myText != null);
    }

    public int hashCode() {
        return this.myText != null ? this.myText.hashCode() : 0;
    }
}

